/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import org.mockserver.codec.MockServerServerCodec;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.mockserver.callback.WebSocketServerHandler;
import org.mockserver.server.unification.PortUnificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerInitializer
extends PortUnificationHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MockServerMatcher mockServerMatcher;
    private final MockServer mockServer;
    private final WebSocketClientRegistry webSocketClientRegistry;

    public MockServerInitializer(MockServerMatcher mockServerMatcher, MockServer mockServer, WebSocketClientRegistry webSocketClientRegistry) {
        this.mockServerMatcher = mockServerMatcher;
        this.mockServer = mockServer;
        this.webSocketClientRegistry = webSocketClientRegistry;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, ChannelPipeline pipeline) {
        if (this.logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(this.logger)});
        }
        boolean isSecure = false;
        if (ctx.channel().attr(PortUnificationHandler.SSL_ENABLED).get() != null) {
            isSecure = (Boolean)ctx.channel().attr(PortUnificationHandler.SSL_ENABLED).get();
        }
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerHandler(this.webSocketClientRegistry)});
        pipeline.addLast(new ChannelHandler[]{new MockServerServerCodec(isSecure)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHandler(this.mockServer, this.mockServerMatcher, this.webSocketClientRegistry, (RequestLogFilter)ctx.channel().attr(MockServer.LOG_FILTER).get())});
    }
}

