/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.therlink;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.common.util.EidUtils;
import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.therlink.domain.Proof;
import be.ehealth.businessconnector.therlink.domain.requests.PutTherapeuticLinkRequest;
import be.ehealth.businessconnector.therlink.exception.TherLinkBusinessConnectorException;
import be.ehealth.businessconnector.therlink.exception.TherLinkBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.therlink.mappers.PatientMapper;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import org.apache.commons.lang.StringUtils;

public final class DefaultImplementationForgeneralPractitioner {
    private static final String GPCONSULTATION = "gpconsultation";

    private DefaultImplementationForgeneralPractitioner() {
    }

    public static PutTherapeuticLinkRequest createDefaultTherapeuticLinkWithEidReading() throws TechnicalConnectorException, TherLinkBusinessConnectorException, InstantiationException {
        Proof proof = RequestObjectBuilderFactory.getProofBuilder().createProofForEidReading();
        return DefaultImplementationForgeneralPractitioner.createDefaultPutTherapeuticLinkRequestWithProof(proof);
    }

    private static PutTherapeuticLinkRequest createDefaultPutTherapeuticLinkRequestWithProof(Proof proof) throws TechnicalConnectorException, TherLinkBusinessConnectorException, InstantiationException {
        Patient patient = PatientMapper.mapPatient(EidUtils.readFromEidCard());
        return DefaultImplementationForgeneralPractitioner.createDefaultPutTherapeuticLinkRequestWithProofAndPatient(proof, patient);
    }

    private static PutTherapeuticLinkRequest createDefaultPutTherapeuticLinkRequestWithProofAndPatient(Proof proof, Patient patient) throws TechnicalConnectorException, TherLinkBusinessConnectorException, InstantiationException {
        RequestObjectBuilder requestObjectBuilder = RequestObjectBuilderFactory.getRequestObjectBuilder();
        return requestObjectBuilder.createPutTherapeuticLinkRequest(null, patient, null, GPCONSULTATION, null, proof);
    }

    public static PutTherapeuticLinkRequest createDefaultTherapeuticLinkWithEidSigning() throws TechnicalConnectorException, TherLinkBusinessConnectorException, InstantiationException {
        Proof proof = RequestObjectBuilderFactory.getProofBuilder().createProofForEidSigning((Credential)BeIDCredential.getInstance((String)"doctor", (String)"Signature"));
        return DefaultImplementationForgeneralPractitioner.createDefaultPutTherapeuticLinkRequestWithProof(proof);
    }

    public static PutTherapeuticLinkRequest createDefaultTherapeuticLinkWithSisReading(Patient patient) throws TherLinkBusinessConnectorException, TechnicalConnectorException, InstantiationException {
        if (StringUtils.isEmpty((String)patient.getSisCardNumber())) {
            throw new TherLinkBusinessConnectorException(TherLinkBusinessConnectorExceptionValues.REQUIRED_FIELD_NULL, "the sis card number field of the patient should be filled out");
        }
        if (patient.getInss() == null) {
            throw new TherLinkBusinessConnectorException(TherLinkBusinessConnectorExceptionValues.REQUIRED_FIELD_NULL, "the niss number field of the patient should be filled out");
        }
        Proof proof = RequestObjectBuilderFactory.getProofBuilder().createProofForEidReading();
        return DefaultImplementationForgeneralPractitioner.createDefaultPutTherapeuticLinkRequestWithProofAndPatient(proof, patient);
    }

    public static PutTherapeuticLinkRequest createDefaultTherapeuticLinkWithIsiReading(Patient patient) throws TherLinkBusinessConnectorException, TechnicalConnectorException, InstantiationException {
        if (StringUtils.isEmpty((String)patient.getIsiCardNumber())) {
            throw new TherLinkBusinessConnectorException(TherLinkBusinessConnectorExceptionValues.REQUIRED_FIELD_NULL, "the isi + card number field of the patient should be filled out");
        }
        if (patient.getInss() == null) {
            throw new TherLinkBusinessConnectorException(TherLinkBusinessConnectorExceptionValues.REQUIRED_FIELD_NULL, "the niss number field of the patient should be filled out");
        }
        Proof proof = RequestObjectBuilderFactory.getProofBuilder().createProofForIsiReading();
        return DefaultImplementationForgeneralPractitioner.createDefaultPutTherapeuticLinkRequestWithProofAndPatient(proof, patient);
    }
}

