/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.builders;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.fgov.ehealth.technicalconnector.ra.utils.CertificateUtils;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public final class EncryptionTokenBuilder {
    private EncryptionTokenBuilder() {
        throw new UnsupportedOperationException();
    }

    static class Steps
    implements KeyPairStep,
    ChallengeStep,
    BuildStep {
        private KeyPair pair;
        private byte[] challenge;
        private Credential cred;

        public Steps(Credential cred) {
            this.cred = cred;
        }

        @Override
        public ChallengeStep withKeyPair(KeyPair pair) {
            Validate.notNull((Object)pair);
            this.pair = pair;
            return this;
        }

        @Override
        public BuildStep withChallenge(byte[] challenge) {
            Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])challenge));
            this.challenge = ArrayUtils.clone((byte[])challenge);
            return this;
        }

        @Override
        public X509Certificate build() throws TechnicalConnectorException {
            return CertificateUtils.generateCert(this.pair.getPublic(), CertificateUtils.obtainSerialNumber(this.pair.getPrivate(), this.challenge), this.cred);
        }
    }

    public static interface BuildStep {
        public X509Certificate build() throws TechnicalConnectorException;
    }

    public static interface ChallengeStep {
        public BuildStep withChallenge(byte[] var1);
    }

    public static interface KeyPairStep {
        public ChallengeStep withKeyPair(KeyPair var1);
    }

    static class EncryptionTokenBuilderSteps
    implements EncryptionTokenBuilderStep {
        private Credential cred;

        public EncryptionTokenBuilderSteps(Credential cred) {
            this.cred = cred;
        }

        @Override
        public KeyPairStep create() {
            return new Steps(this.cred);
        }
    }

    public static interface EncryptionTokenBuilderStep {
        public KeyPairStep create();
    }
}

