/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import be.fgov.ehealth.etee.crypto.policies.ForwardingMap;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.util.HashMap;
import java.util.Map;

public final class OCSPOptions
extends ForwardingMap<OCSPOption, Object> {
    private static final int DEFAULT_READ_TIMEOUT = 3000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 3000;
    private static final long DEFAULT_CLOCK_SKEW = 300000L;
    private final Map<OCSPOption, Object> delegate = new HashMap<OCSPOption, Object>();

    public OCSPOptions() {
        this.delegate.put(OCSPOption.OCSP_URI, null);
        this.delegate.put(OCSPOption.TRUST_STORE, null);
        this.delegate.put(OCSPOption.INJECT_RESPONSE, Boolean.FALSE);
        this.delegate.put(OCSPOption.CLOCK_SKEW, 300000L);
        this.delegate.put(OCSPOption.CONNECTION_TIMEOUT, 3000);
        this.delegate.put(OCSPOption.READ_TIMEOUT, 3000);
        this.delegate.put(OCSPOption.CONNECTION_USER_INTERACTION, Boolean.TRUE);
    }

    public static OCSPOptions defaultOptions() {
        return new OCSPOptions();
    }

    public static OCSPOptions create() {
        OCSPOptions options = OCSPOptions.defaultOptions();
        options.clear();
        return options;
    }

    public OCSPOptions set(OCSPOption option, Object value) {
        if (value != null) {
            this.delegate.put(option, value);
        }
        return this;
    }

    public OCSPOptions setAll(Map<OCSPOption, Object> options) {
        for (Map.Entry<OCSPOption, Object> entry : options.entrySet()) {
            if (entry.getValue() == null) continue;
            this.delegate.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String getString(OCSPOption ocspOption) {
        return this.valueOf((Object)ocspOption, String.class);
    }

    public Boolean getBoolean(OCSPOption ocspOption) {
        return this.valueOf((Object)ocspOption, Boolean.class);
    }

    public KeyStore getKeyStore(OCSPOption ocspOption) {
        return this.valueOf((Object)ocspOption, KeyStore.class);
    }

    public CertStore getCertStore(OCSPOption ocspOption) {
        return this.valueOf((Object)ocspOption, CertStore.class);
    }

    public Long getLong(OCSPOption ocspOption) {
        return this.valueOf((Object)ocspOption, Long.class);
    }

    public Integer getInteger(OCSPOption ocspOption) {
        return this.valueOf((Object)ocspOption, Integer.class);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("OCSPOptions : ");
        for (Map.Entry<OCSPOption, Object> entry : this.delegate.entrySet()) {
            stringBuilder.append(String.format(" [%s = %s] ", new Object[]{entry.getKey(), entry.getValue()}));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Map && obj.equals(this.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    protected Map<OCSPOption, Object> delegate() {
        return this.delegate;
    }
}

