package be.ehealth.technicalconnector.session;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.service.sts.utils.SAMLHelper;
import be.ehealth.technicalconnector.session.renew.RenewStrategyFactory;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.joda.time.DateTime;
import org.junit.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

import static be.ehealth.technicalconnector.session.renew.RenewStrategy.PROP_AUTO_RENEW;
import static be.ehealth.technicalconnector.session.renew.SlidingWindowRenewStrategy.SLIDING_WINDOW_DIVIDER;

@Ignore
public class SlidingWindowSessionManagerIntegrationTest extends AbstractSessionManagerIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(SlidingWindowSessionManagerIntegrationTest.class);

    @ClassRule
    public static SessionRule rule = SessionRule.withInactiveSession().build();

    @Before
    @After
    public void cleanup() {
        Session.getInstance().unloadSession();
    }

    @Test
    public void test() throws Exception {

        ConfigFactory.getConfigValidator().setProperty(SLIDING_WINDOW_DIVIDER, "2400");
        ConfigFactory.getConfigValidator().setProperty(PROP_AUTO_RENEW, "true");
        SessionManager sessionmgmgt = Session.getInstance();
        SessionItem session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"), props.getProperty("test.session.encryption.password"));
        DateTime beforeRenew = SAMLHelper.getNotOnOrAfterCondition(session.getSAMLToken().getAssertion());

        TimeUnit.SECONDS.sleep(60);

        DateTime afterRenew = SAMLHelper.getNotOnOrAfterCondition(sessionmgmgt.getSession().getSAMLToken().getAssertion());
        Assert.assertTrue("SlidingWindow Renew doesn't work!", afterRenew.isAfter(beforeRenew));

    }

    @Test
    public void slidingWindowOnExpiredToken() throws Exception {

        ConfigValidator config = ConfigFactory.getConfigValidator();

        config.setProperty(SLIDING_WINDOW_DIVIDER, "2");
        config.setProperty(PROP_AUTO_RENEW, "false");
        config.setProperty("sessionmanager.validity.token.duration", "30");
        config.setProperty("sessionmanager.validity.token.timeunit", "SECONDS");

        SessionManager sessionmgmgt = Session.getInstance();
        SessionItem session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"), props.getProperty("test.session.encryption.password"));
        DateTime beforeRenew = SAMLHelper.getNotOnOrAfterCondition(session.getSAMLToken().getAssertion());

        while (beforeRenew.isAfterNow()) {
            TimeUnit.SECONDS.sleep(1);
        }
        Assert.assertFalse(sessionmgmgt.hasValidSession());

        config.setProperty(PROP_AUTO_RENEW, "true");
        config.setProperty("sessionmanager.validity.token.duration", "40");
        config.setProperty("sessionmanager.validity.token.timeunit", "SECONDS");
        sessionmgmgt.hasValidSession();


        DateTime afterRenew = SAMLHelper.getNotOnOrAfterCondition(sessionmgmgt.getSession().getSAMLToken().getAssertion());
        Assert.assertTrue("SlidingWindow Renew doesn't work!", afterRenew.isAfter(beforeRenew));
        sessionmgmgt.unloadSession();

    }
}
