/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.ehbox.v3.session;

import java.util.Date;
import java.util.Properties;

import be.ehealth.businessconnector.ehbox.v3.session.EhealthBoxServiceV3;
import be.ehealth.businessconnector.ehbox.v3.session.ServiceFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.test.ehbox.v3.EhboxTestDataBuilder;
import be.ehealth.businessconnector.test.ehbox.v3.EhboxTestUtilities;
import be.ehealth.businessconnector.ehbox.v3.builders.BuilderFactory;
import be.ehealth.businessconnector.ehbox.v3.builders.SendMessageBuilder;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetFullMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetFullMessageResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.Message;
import be.fgov.ehealth.ehbox.core.v3.BoxIdType;
import be.fgov.ehealth.ehbox.publication.protocol.v3.SendMessageRequest;
import be.fgov.ehealth.ehbox.publication.protocol.v3.SendMessageResponse;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * test for jira issue EHCONEXT-85 and EHCON-570. sending a message with empty content for attachment.
 * 
 * caused NegativeArraySizeException
 * 
 * @author EHP
 * 
 */
public class Ehconext85EmptyAttachmentIntegrationTest {

    private static final String TEST_PROPERTIES_FILE = "/be.ehealth.businessconnector.ehboxv3.test.properties";

    private static final Logger LOG = LoggerFactory.getLogger(EhboxV3ServicePublicationIntegrationTest.class);

    @BeforeClass
    public static void initSession() throws Exception {
        Properties props = TestPropertiesLoader.getProperties(TEST_PROPERTIES_FILE);
        SessionInitializer.init(props, true);
    }


    @AfterClass
    public static void unloadSession() throws Exception {
        Session.getInstance().unloadSession();
    }


    @Test
    public void testSendingMessageWithEmptyContent() throws Exception {

        SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

        DocumentMessage<Message> doc = new DocumentMessage<Message>();

        Document document = new Document();
        document.setTitle("document " + new Date());
        document.setContent("".getBytes());
        document.setFilename("test.txt");
        document.setMimeType("text/plain");
        doc.setDocument(document);
        doc.getDestinations().add(EhboxTestDataBuilder.getSenderAsAddressee());

        SendMessageRequest request = builder.buildMessage(doc);
        /*
         * Invoke the business connector framework's eHealthBox's sendMessage operation
         */
        EhealthBoxServiceV3 service = ServiceFactory.getEhealthBoxServiceV3();
        SendMessageResponse response = service.sendMessage(request);
        /*
         * Verify the response
         */
        // check if there are no errors
        Assert.assertEquals("100", response.getStatus().getCode());
        // check if a messageId has been returned
        Assert.assertNotNull(response.getId());

        LOG.debug("Message Sent: " + response.getId());
        EhboxTestUtilities.waitForProcessing();
        GetFullMessageRequest getFullMessageRequest = BuilderFactory.getRequestBuilder().createGetFullMessageRequest(response.getId());
        setBoxId(request, getFullMessageRequest);
        GetFullMessageResponse fullMessage = service.getFullMessage(getFullMessageRequest);
        Assert.assertNotNull(fullMessage);
        be.ehealth.businessconnector.ehbox.api.domain.Message<GetFullMessageResponse> retrievedFullMessage = BuilderFactory.getConsultationMessageBuilder().buildFullMessage(fullMessage);
        Assert.assertNotNull(retrievedFullMessage);

    }

    /**
     * @param request
     * @param getFullMessageRequest
     */
    private void setBoxId(SendMessageRequest request, GetFullMessageRequest getFullMessageRequest) {
        BoxIdType boxId = new BoxIdType();
        boxId.setId(request.getDestinationContexts().get(0).getId());
        boxId.setQuality(request.getDestinationContexts().get(0).getQuality());
        boxId.setType(request.getDestinationContexts().get(0).getType());
        getFullMessageRequest.setBoxId(boxId);
    }

}
