/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.ehbox.v3;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.businessconnector.ehbox.v3.builders.BuilderFactory;
import be.ehealth.businessconnector.ehbox.v3.session.EhealthBoxServiceV3;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessageListResponseType;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.Message;
import be.fgov.ehealth.technicalconnector.tests.session.SessionDestroyer;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * cleans the ehbox completely.
 * 
 * @author EH076
 * 
 * @since
 * 
 */
public class CleanEhboxCompletely {

    private static final Logger LOG = LoggerFactory.getLogger(CleanEhboxCompletely.class);


    public static void main(String[] args) {
        Properties props;
        Map<String, Long> processedItemsMap = new HashMap<String, Long>();
        try {
            props = TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.ehboxv3.test.properties");
            SessionInitializer.init(props, true);
            EhealthBoxServiceV3 service = be.ehealth.businessconnector.ehbox.v3.session.ServiceFactory.getEhealthBoxServiceV3();

            for (String source : EhboxTestUtilities.getListOfAllSources()) {
                long processed = 0L;
                long errors = 0L;
                GetMessageListResponseType allEhboxesMessagesList = service.getAllEhboxesMessagesList(BuilderFactory.getRequestBuilder().createAllEhboxesMessagesListRequest(source));
                for (Message message : allEhboxesMessagesList.getMessages()) {
                    // TODO : now only works for main ehbox , boxIdToUse doesn't work correctly yet
                    // BoxIdType boxIdToUse = mapSender(message.getSender());
                    try {
                        service.deleteMessage(BuilderFactory.getRequestBuilder().createDeleteMessageRequest(source, message.getMessageId()));
                        processed++;
                    } catch (Exception e) {
                        errors++;
                        LOG.error("error occurred : " + e.getMessage() + " while processing message with id " + message.getMessageId() + " published on " + message.getMessageInfo().getPublicationDate() + " for source " + source);

                    }
                }
                processedItemsMap.put(source, processed);
                processedItemsMap.put("ERRORS " + source, errors);
            }
            SessionDestroyer.destroy();
            LOG.warn("finished ");
            for (String key : processedItemsMap.keySet()) {
                LOG.warn(" source " + key + ": " + processedItemsMap.get(key));
            }
        } catch (Exception e1) {
            LOG.error(e1.getMessage());
        }
    }

    // private static BoxIdType mapSender(SenderType sender) {
    // if (sender != null) {
    // BoxIdType boxIdType = new BoxIdType();
    // boxIdType.setId(sender.getId());
    // boxIdType.setQuality(sender.getQuality());
    // boxIdType.setType(sender.getType());
    // boxIdType.setSubType(sender.getSubType());
    // return boxIdType;
    // }
    // return null;
    // }


}
