package be.ehealth.businessconnector.test.consultrnv2.session;

import be.ehealth.businessconnector.consultrnv2.session.ConsultrnSessionServiceFactory;
import be.ehealth.businessconnector.test.consultrnv2.session.support.RequestTransformer;
import be.ehealth.technicalconnector.exception.SoaErrorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.rn.cbsspersonservice.protocol.v1.RegisterPersonRequest;
import be.fgov.ehealth.rn.cbsspersonservice.protocol.v1.RegisterPersonResponse;
import be.fgov.ehealth.rn.registries.commons.v1.DetailedStatusType;
import be.fgov.ehealth.rn.registries.commons.v1.ValidationErrors;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.w3c.dom.Element;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class ConsultrnSessionCBSSPersonServiceIntegrationTest {

    private static final RequestTransformer TRANSFORMER = new RequestTransformer();

    @ClassRule
    public static SessionRule sessionRule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.consultrnv2.test.properties").build();

    @Test
    public void testRegisterPerson() throws Exception {
        RegisterPersonRequest request = TRANSFORMER.transform("/examples/request/registerPersonRequest.xml", RegisterPersonRequest.class);
        RegisterPersonResponse response = ConsultrnSessionServiceFactory.getConsultrnCBSSPersonService().registerPerson(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/registerPersonResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void testRegisterPersonWithError() throws Exception {
        try {
            RegisterPersonRequest request = TRANSFORMER.transform("/examples/request/registerPersonRequest-error.xml", RegisterPersonRequest.class);
            ConsultrnSessionServiceFactory.getConsultrnCBSSPersonService().registerPerson(request);
        } catch (SoaErrorException see) {
            RegisterPersonResponse response = (RegisterPersonResponse) see.getResponseTypeV2();
            Assert.assertEquals("Business validation error", response.getStatus().getStatusMessage());

            Element elt = (Element) response.getStatus().getStatusDetail().getAnies().get(0);
            JAXBContext context = JaxbContextFactory.getJaxbContextForClass(ValidationErrors.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            ValidationErrors errors = (ValidationErrors) unmarshaller.unmarshal(elt);

            DetailedStatusType validationError = errors.getValidationErrors().get(0);
            Assert.assertEquals("800036", validationError.getCode());
            Assert.assertEquals("Person has no valid MID", validationError.getDescription());
        }
    }

}
