/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.services;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SAMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLUtils.class);
    private static final String ASSERTION_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:assertion";
    private static final String PROTOCOL_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:protocol";

    public static String getStatusCode(Element response) {
        Element statusCode = ConnectorXmlUtils.getFirstElementByTagNameNS((Element)response, (String)PROTOCOL_NAMESPACE, (String)"StatusCode");
        if (statusCode != null) {
            return statusCode.getAttribute("Value");
        }
        throw new IllegalArgumentException();
    }

    public static String getStatusMessage(Element response) {
        Element status = ConnectorXmlUtils.getFirstElementByTagNameNS((Element)response, (String)PROTOCOL_NAMESPACE, (String)"Status");
        Element statusMessage = ConnectorXmlUtils.getFirstElementByTagNameNS((Element)status, (String)PROTOCOL_NAMESPACE, (String)"StatusMessage");
        if (statusMessage != null) {
            return statusMessage.getTextContent();
        }
        throw new IllegalArgumentException();
    }

    public static NodeList getAssertions(Element response) {
        return response.getElementsByTagNameNS(ASSERTION_NAMESPACE, "Assertion");
    }

    public static void validateAssertions(Element response) throws TechnicalConnectorException {
        NodeList assertions = SAMLUtils.getAssertions(response);
        for (int i = 0; i < assertions.getLength(); ++i) {
            SAMLUtils.validateAssertion((Element)assertions.item(i));
        }
    }

    public static void validateAssertion(Element assertion) throws TechnicalConnectorException {
        byte[] signed = ConnectorXmlUtils.toByteArray((Node)assertion);
        String id = assertion.getAttributes().getNamedItem("ID").getTextContent();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("baseURI", id);
        SignatureVerificationResult verificationResult = SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XML).verify(signed, options);
        if (!verificationResult.isValid()) {
            if (!verificationResult.getErrors().contains(SignatureVerificationError.SIGNATURE_NOT_PRESENT)) {
                for (SignatureVerificationError signatureVerificationError : verificationResult.getErrors()) {
                    LOG.error(signatureVerificationError.getMessage());
                }
                throw new IllegalArgumentException();
            }
        } else {
            LOG.debug("SAML assertion correctly signed!");
        }
    }
}

