/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.dialogs;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.CancelledException;
import be.fedict.commons.eid.client.FileType;
import be.fedict.commons.eid.client.OutOfCardsException;
import be.fedict.commons.eid.client.event.BeIDCardListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.security.auth.x500.X500Principal;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class BeIDSelector {
    private JDialog dialog;
    private JPanel masterPanel;
    private DefaultListModel listModel;
    private JList list;
    private final Component parentComponent;
    private final ListData selectedListData;
    private final Map<BeIDCard, ListDataUpdater> updaters;
    private int identitiesbeingRead;
    private boolean outOfCards;

    public BeIDSelector(Component parentComponent, String title, Collection<BeIDCard> initialCards) {
        this.parentComponent = parentComponent;
        this.selectedListData = new ListData(null);
        this.updaters = new HashMap<BeIDCard, ListDataUpdater>();
        this.identitiesbeingRead = 0;
        this.outOfCards = false;
        this.initComponents(title, initialCards);
        for (BeIDCard card : initialCards) {
            this.addEIDCard(card);
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int index;
                JList theList = (JList)mouseEvent.getSource();
                if (mouseEvent.getClickCount() == 2 && (index = theList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    BeIDSelector.this.stop();
                    Object object = theList.getModel().getElementAt(index);
                    ListData listData = (ListData)object;
                    BeIDSelector.this.selectedListData.card = listData.getCard();
                    BeIDSelector.this.dialog.dispose();
                }
            }
        };
        this.list.addMouseListener(mouseListener);
    }

    public void addEIDCard(BeIDCard card) {
        ListData listData = new ListData(card);
        this.addToList(listData);
        ListDataUpdater listDataUpdater = new ListDataUpdater(this, listData);
        this.updaters.put(card, listDataUpdater);
        listDataUpdater.start();
    }

    public void removeEIDCard(BeIDCard card) {
        ListDataUpdater listDataUpdater = this.updaters.get(card);
        listDataUpdater.stop();
        this.updaters.remove(card);
        this.removeFromList(listDataUpdater.getListData());
    }

    public synchronized void startReadingIdentity() {
        ++this.identitiesbeingRead;
        this.notifyAll();
    }

    public synchronized void endReadingIdentity() {
        --this.identitiesbeingRead;
        this.repack();
        this.notifyAll();
    }

    public synchronized void waitUntilIdentitiesRead() {
        try {
            while (this.identitiesbeingRead > 0) {
                this.wait();
            }
        }
        catch (InterruptedException iex) {
            return;
        }
    }

    public void stop() {
        for (ListDataUpdater updater : this.updaters.values()) {
            updater.stop();
        }
        for (ListDataUpdater updater : this.updaters.values()) {
            try {
                updater.join();
            }
            catch (InterruptedException iex) {
                return;
            }
        }
    }

    public BeIDCard choose() throws OutOfCardsException, CancelledException {
        this.waitUntilIdentitiesRead();
        this.dialog.setLocationRelativeTo(this.parentComponent);
        this.dialog.setResizable(false);
        this.dialog.setVisible(true);
        if (this.outOfCards) {
            throw new OutOfCardsException();
        }
        if (this.selectedListData.getCard() == null) {
            throw new CancelledException();
        }
        return this.selectedListData.getCard();
    }

    private void initComponents(final String title, Collection<BeIDCard> initialCards) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BeIDSelector.this.dialog = new JDialog((Frame)null, title, true);
                    BeIDSelector.this.masterPanel = new JPanel(new BorderLayout());
                    BeIDSelector.this.masterPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
                    BeIDSelector.this.listModel = new DefaultListModel();
                    BeIDSelector.this.list = new JList(BeIDSelector.this.listModel);
                    BeIDSelector.this.list.setCellRenderer(new EidListCellRenderer());
                    BeIDSelector.this.masterPanel.add(BeIDSelector.this.list);
                    BeIDSelector.this.dialog.add(BeIDSelector.this.masterPanel);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private synchronized void updateListData(ListDataUpdater listDataUpdater, final ListData listData) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int index = BeIDSelector.this.listModel.indexOf(listData);
                if (index != -1) {
                    BeIDSelector.this.listModel.set(index, listData);
                }
            }
        });
    }

    private void addToList(final ListData listData) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BeIDSelector.this.listModel.addElement(listData);
            }
        });
    }

    private void removeFromList(final ListData listData) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BeIDSelector.this.listModel.removeElement(listData);
                if (BeIDSelector.this.listModel.isEmpty()) {
                    BeIDSelector.this.selectedListData.card = null;
                    BeIDSelector.this.outOfCards = true;
                    BeIDSelector.this.dialog.dispose();
                } else {
                    BeIDSelector.this.dialog.pack();
                }
            }
        });
    }

    private void repack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BeIDSelector.this.dialog.pack();
            }
        });
    }

    private static class ListDataUpdater
    implements Runnable {
        private final BeIDSelector selectionDialog;
        private final ListData listData;
        private final Thread worker;

        public ListDataUpdater(BeIDSelector selectionDialog, ListData listData) {
            this.selectionDialog = selectionDialog;
            this.listData = listData;
            this.worker = new Thread((Runnable)this, "ListDataUpdater");
            this.worker.setDaemon(true);
            this.setWorkerName(null, null);
            this.selectionDialog.startReadingIdentity();
        }

        public void stop() {
            this.worker.interrupt();
        }

        public void start() {
            this.worker.start();
        }

        public void join() throws InterruptedException {
            this.worker.join();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            X509Certificate authCert = null;
            this.setWorkerName(null, "Reading Identity");
            try {
                byte[] authCertData = this.listData.getCard().readFile(FileType.AuthentificationCertificate);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                authCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(authCertData));
                this.listData.setAuthCert(authCert);
                this.selectionDialog.updateListData(this, this.listData);
                this.setWorkerName(authCert, "Identity Read");
            }
            catch (Exception ex) {
                this.listData.setError();
                this.selectionDialog.updateListData(this, this.listData);
                this.setWorkerName(authCert, "Error Reading Identity");
            }
            finally {
                this.selectionDialog.endReadingIdentity();
            }
            this.setWorkerName(authCert, "Reading Photo");
            try {
                this.listData.setPhotoSizeEstimate(FileType.Photo.getEstimatedMaxSize());
                this.selectionDialog.updateListData(this, this.listData);
                this.listData.getCard().addCardListener(new BeIDCardListener(){

                    public void notifyReadProgress(FileType fileType, int offset, int estimatedMaxSize) {
                        listData.setPhotoProgress(offset);
                        selectionDialog.updateListData(this, listData);
                    }

                    public void notifySigningBegin(FileType keyType) {
                    }

                    public void notifySigningEnd(FileType keyType) {
                    }
                });
                byte[] photoFile = this.listData.getCard().readFile(FileType.Photo);
                BufferedImage photoImage = ImageIO.read(new ByteArrayInputStream(photoFile));
                this.listData.setPhoto(new ImageIcon(photoImage));
                this.selectionDialog.updateListData(this, this.listData);
                this.setWorkerName(authCert, "All Done");
            }
            catch (Exception ex) {
                this.listData.setError();
                this.selectionDialog.updateListData(this, this.listData);
                this.setWorkerName(authCert, "Error Reading Photo");
            }
        }

        private void setWorkerName(X509Certificate authCert, String activity) {
            StringBuilder builder = new StringBuilder("ListDataUpdater");
            if (authCert != null) {
                builder.append(" [");
                builder.append(authCert.getSubjectX500Principal().toString());
                builder.append("]");
            }
            if (activity != null) {
                builder.append(" [");
                builder.append(activity);
                builder.append("]");
            }
            this.worker.setName(builder.toString());
        }

        public ListData getListData() {
            return this.listData;
        }
    }

    private static class IdentityPanel
    extends JPanel {
        private static final long serialVersionUID = 1293396834578252226L;

        public IdentityPanel(X509Certificate authCertificate) {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            this.setMinimumSize(new Dimension(140, 200));
            this.setOpaque(false);
            if (authCertificate == null) {
                this.add(new JLabel("-"));
            } else {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.anchor = 21;
                gbc.ipady = 4;
                String givenName = IdentityPanel.getField(authCertificate, "GIVENNAME");
                String surname = IdentityPanel.getField(authCertificate, "SURNAME");
                String text = givenName;
                if (null != text) {
                    if (null != surname) {
                        text = text + " " + surname;
                    }
                } else {
                    text = surname;
                }
                this.add((Component)new JLabel(text), gbc);
            }
        }

        public static String getField(X509Certificate certificate, String field) {
            X500Principal userPrincipal = certificate.getSubjectX500Principal();
            String name = userPrincipal.toString();
            int beginIdx = name.indexOf(field + "=");
            if (-1 == beginIdx) {
                return null;
            }
            int valueBeginIdx = beginIdx + field.length() + "=".length();
            int valueEndIdx = name.indexOf(",", valueBeginIdx);
            if (-1 == valueEndIdx) {
                valueEndIdx = name.length();
            }
            String value = name.substring(valueBeginIdx, valueEndIdx);
            return value;
        }
    }

    private static class PhotoPanel
    extends JPanel {
        private static final long serialVersionUID = -8779658857811406077L;
        private JProgressBar progressBar;

        public PhotoPanel(ImageIcon photo, int progress, int max) {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            Dimension fixedSize = new Dimension(140, 200);
            this.setPreferredSize(fixedSize);
            this.setMinimumSize(fixedSize);
            this.setMaximumSize(fixedSize);
            if (photo == null) {
                this.progressBar = new JProgressBar(0, max);
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(progress);
                fixedSize = new Dimension(100, 16);
                this.progressBar.setPreferredSize(fixedSize);
                this.add(this.progressBar);
            } else {
                this.add(new JLabel(photo));
            }
        }
    }

    private static class EidListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = -6914001662919942232L;

        private EidListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel();
            ListData listData = (ListData)value;
            panel.setLayout(new FlowLayout(0));
            if (listData.hasError()) {
                panel.setBackground(this.redden(isSelected ? list.getSelectionBackground() : list.getBackground()));
            } else {
                panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            }
            panel.add(new PhotoPanel(listData.getPhoto(), listData.getPhotoProgress(), listData.getPhotoSizeEstimate()));
            panel.add(new IdentityPanel(listData.getAuthCert()));
            return panel;
        }

        private Color redden(Color originalColor) {
            Color less = originalColor.darker().darker();
            Color more = originalColor.brighter().brighter();
            return new Color(more.getRed(), less.getGreen(), less.getBlue());
        }
    }

    private static class ListData {
        private X509Certificate authCert;
        private BeIDCard card;
        private ImageIcon photo;
        private int photoProgress;
        private int photoSizeEstimate;
        private boolean error;

        public ListData(BeIDCard card) {
            this.card = card;
        }

        public X509Certificate getAuthCert() {
            return this.authCert;
        }

        public void setAuthCert(X509Certificate authCert) {
            this.authCert = authCert;
        }

        public BeIDCard getCard() {
            return this.card;
        }

        public ImageIcon getPhoto() {
            return this.photo;
        }

        public void setPhoto(ImageIcon photo) {
            this.photo = photo;
        }

        public int getPhotoProgress() {
            return this.photoProgress;
        }

        public void setPhotoProgress(int photoProgress) {
            this.photoProgress = photoProgress;
        }

        public void setPhotoSizeEstimate(int photoSizeEstimate) {
            this.photoSizeEstimate = photoSizeEstimate;
        }

        public int getPhotoSizeEstimate() {
            return this.photoSizeEstimate;
        }

        public boolean hasError() {
            return this.error;
        }

        public void setError() {
            this.error = true;
        }
    }
}

