/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.security.impl;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.impl.AbstractExtendedCredential;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class KeyPairCredential
extends AbstractExtendedCredential {
    private PrivateKey privateKey;
    private X509Certificate certificate;

    public KeyPairCredential(PrivateKey privateKey, X509Certificate certificate) {
        this.privateKey = privateKey;
        this.certificate = certificate;
    }

    @Override
    public String getIssuer() {
        return this.certificate.getSubjectX500Principal().getName("RFC1779");
    }

    @Override
    public String getIssuerQualifier() {
        return this.certificate.getIssuerX500Principal().getName("RFC1779");
    }

    @Override
    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public String getProviderName() {
        throw new UnsupportedOperationException("getProviderName is not supported.");
    }

    @Override
    public Certificate[] getCertificateChain() {
        return new Certificate[]{this.certificate};
    }

    @Override
    public KeyStore getKeyStore() throws TechnicalConnectorException {
        throw new UnsupportedOperationException("getKeyStore is not supported.");
    }
}

