/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler.wss4j;

import be.ehealth.technicalconnector.handler.wss4j.AlgorithmHelper;
import be.ehealth.technicalconnector.handler.wss4j.ECAlgorithmHelper;
import be.ehealth.technicalconnector.handler.wss4j.RSAAlgorithmHelper;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import java.util.ArrayList;
import java.util.List;

public class AlgorithmHelperFactory {
    private static List<AlgorithmHelper> helpers = new ArrayList<AlgorithmHelper>();

    public static AlgorithmHelper getAlgorithmHelper(Credential credential) {
        for (AlgorithmHelper helper : helpers) {
            if (!helper.canHandle(credential)) continue;
            return helper;
        }
        throw new IllegalArgumentException("Unsupported algorithm " + credential);
    }

    static {
        helpers.add(new RSAAlgorithmHelper());
        helpers.add(new ECAlgorithmHelper());
    }
}

