/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.config.impl.TrustManagerFactory;
import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationModuleSSL
implements ConfigurationModule {
    private static final String JAVAX_NET_DEBUG = "javax.net.debug";
    private static final String CONNECTOR_CONFIGURATIONMODULE_SSL_DEBUG = "connector.configurationmodule.ssl.debug";
    public static final String CONNECTOR_CONFIGURATIONMODULE_SSL_VERIFICATIONFLAVOUR = "connector.configurationmodule.ssl.verifcation.flavour";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleSSL.class);
    public static final String SSL_VERIFICATION_FLAVOUR_PASSTHROUGH = "passthrough";
    public static final String SSL_VERIFICATION_FLAVOUR_TRUSTSTORE = "truststore";
    private SSLSocketFactory oldDefaultSSLSocketFactory;

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        LOG.debug("Initializing ConfigurationModule {}", (Object)this.getClass().getName());
        try {
            TrustManager[] trustManagers;
            this.oldDefaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            SSLContext sc = SSLContext.getInstance("SSL");
            String sslVerifationFlavour = config.getProperty(CONNECTOR_CONFIGURATIONMODULE_SSL_VERIFICATIONFLAVOUR, SSL_VERIFICATION_FLAVOUR_TRUSTSTORE);
            if (SSL_VERIFICATION_FLAVOUR_PASSTHROUGH.equals(sslVerifationFlavour)) {
                trustManagers = new TrustManager[]{TrustManagerFactory.passThroughTrustManager()};
            } else if (SSL_VERIFICATION_FLAVOUR_TRUSTSTORE.equals(sslVerifationFlavour)) {
                trustManagers = new TrustManager[]{TrustManagerFactory.keystoreTrustManager(config)};
            } else {
                throw new ConfigurationException("Unsupported SSL verifcation flavour " + sslVerifationFlavour);
            }
            sc.init(null, trustManagers, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }

    @Override
    public void unload() throws TechnicalConnectorException {
        LOG.debug("Unloading ConfigurationModule {}", (Object)this.getClass().getName());
        HttpsURLConnection.setDefaultSSLSocketFactory(this.oldDefaultSSLSocketFactory);
    }
}

