/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.unitils.core.UnitilsException;
import org.unitils.util.ReflectionUtils;

public class PropertyUtils {
    public static String getString(String propertyName, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        return value.trim();
    }

    public static String getString(String propertyName, String defaultValue, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return value.trim();
    }

    public static List<String> getStringList(String propertyName, Properties properties) {
        return PropertyUtils.getStringList(propertyName, properties, false);
    }

    public static List<String> getStringList(String propertyName, Properties properties, boolean required) {
        String values = properties.getProperty(propertyName);
        if (values == null || "".equals(values.trim())) {
            if (required) {
                throw new UnitilsException("No value found for property " + propertyName);
            }
            return new ArrayList<String>(0);
        }
        String[] splitValues = values.split(",");
        ArrayList<String> result = new ArrayList<String>(splitValues.length);
        for (String value : splitValues) {
            result.add(value.trim());
        }
        if (required && result.isEmpty()) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        return result;
    }

    public static boolean getBoolean(String propertyName, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        return PropertyUtils.toBoolean(propertyName, value);
    }

    public static boolean getBoolean(String propertyName, boolean defaultValue, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return PropertyUtils.toBoolean(propertyName, value);
    }

    private static boolean toBoolean(String propertyName, String value) {
        if ("true".equalsIgnoreCase(value = value.trim())) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a boolean.");
    }

    public static long getLong(String propertyName, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public static long getLong(String propertyName, long defaultValue, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public static int getInt(String propertyName, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public static int getInt(String propertyName, int defaultValue, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public static boolean containsProperty(String propertyName, Properties properties) {
        return properties.getProperty(propertyName) != null;
    }

    public static <T> T getInstance(String propertyName, Properties properties) {
        String className = PropertyUtils.getString(propertyName, properties);
        return ReflectionUtils.createInstanceOfType(className, false);
    }

    public static <T> T getInstance(String propertyName, T defaultValue, Properties properties) {
        String className = PropertyUtils.getString(propertyName, null, properties);
        if (className == null) {
            return defaultValue;
        }
        return ReflectionUtils.createInstanceOfType(className, false);
    }
}

