﻿using System;
using NUnit.Framework;

using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.businessconnector.consultrnv2.session.support;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.utils.impl;
using be.fgov.ehealth.rn.cbsspersonservice.protocol.v1;
using be.fgov.ehealth.technicalconnector.tests.junit.rule;
using be.fgov.ehealth.rn.registries.commons.v1;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using org.w3c.dom;
using javax.xml.bind;
using java.util;
using java.lang;

namespace be.ehealth.businessconnector.consultrnv2.session
{
	[TestFixture]
	public class ConsultrnSessionCBSSPersonServiceIntegrationTest
	{
		[SetUpAttribute]
	    public static void setupsession() {
	    	SessionInitializer.init(".\\be.ehealth.businessconnector.consultrnv2.test.properties",true, SupportedLanguages.NET.getAbbreviation());
	    }
		
		[Test]
		public void testRegisterPerson() {
			RequestTransformer transformer = new RequestTransformer();
	    	RegisterPersonRequest request = transformer.transform<RegisterPersonRequest>(".\\examples\\request\\registerPersonRequest.xml", typeof(RegisterPersonRequest));
	        RegisterPersonResponse response = ConsultrnSessionServiceFactory.getConsultrnCBSSPersonService().registerPerson(request);
	        be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\registerPersonResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
		
		[Test]
		public void testRegisterPersonWithError() {
			try {
				RequestTransformer transformer = new RequestTransformer();
				RegisterPersonRequest request = transformer.transform<RegisterPersonRequest>(".\\examples\\request\\registerPersonRequest-error.xml", typeof(RegisterPersonRequest));
	            ConsultrnSessionServiceFactory.getConsultrnCBSSPersonService().registerPerson(request);
	        } catch (SoaErrorException see) {
	            RegisterPersonResponse response = (RegisterPersonResponse) see.getResponseTypeV2();
	            Assert.AreEqual("Business validation error", response.getStatus().getStatusMessage());
	
	            org.w3c.dom.Element elt = (org.w3c.dom.Element) response.getStatus().getStatusDetail().getAnies().get(0);
	            JAXBContext context = JaxbContextFactory.getJaxbContextForClass(typeof(ValidationErrors));
	            Unmarshaller unmarshaller = context.createUnmarshaller();
	            ValidationErrors errors = (ValidationErrors) unmarshaller.unmarshal(elt);
	
	            DetailedStatusType validationError = (DetailedStatusType) errors.getValidationErrors().get(0);
	            Assert.AreEqual("800036", validationError.getCode());
	            Assert.AreEqual("Person has no valid MID", validationError.getDescription());
	        }
		}
	}
}
