/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.sts.security.impl;


import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.SAMLTokenFactory;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;


/**
 * Class to verify the {@link SAMLHolderOfKeyToken}
 * 
 * @author EHP
 */
public class SAMLHolderOfKeyTokenTest {

    private SAMLToken token;

    @Before
    public void init() throws Exception {
        Element assertion = ConnectorXmlUtils.toElement(ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream("/examples/sas/renew.eid.sas")));
        Credential credential = BeIDCredential.getInstance("", BeIDCredential.EID_AUTH_ALIAS);
        token = SAMLTokenFactory.getInstance()
                                .createSamlToken(assertion, credential);

    }

    @Test
    public void isHolderOfKeyToken() throws Exception {
        Assert.assertThat(token, CoreMatchers.instanceOf(SAMLHolderOfKeyToken.class));
    }

    @Test(expected = TechnicalConnectorException.class)
    public void isNotValid() throws Exception {
        token.checkValidity();
    }

    @Test
    public void getAssertionId() throws Exception {
        String expected = "_c6f245c3bf81f68e034dc101f64d88b2";
        Assert.assertEquals(expected, token.getAssertionID());
    }


}
