/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.test.kmehrcommons.builders;

import be.ehealth.business.kmehrcommons.builders.HcPartyBuilder;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDADDRESSschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCOUNTRYschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.AddressType;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;


/**
 * Test for the non yet tested method of HcPartyBuilder
 * 
 * @author EHP
 * 
 */
public class HcPartyBuilderTest {

    /**
     * Test method for {@link be.ehealth.business.kmehrcommons.builders.HcPartyBuilder#id(java.lang.String, java.lang.String)}.
     */
    @Test
    public void testMethodIdAndCd1() throws TechnicalConnectorException {
        HcPartyBuilder hcpBuilder = new HcPartyBuilder();
        hcpBuilder.id("1.0", "x").cd("1.1", "x", CDHCPARTYschemes.CD_HCPARTY);
        HcpartyType builded = hcpBuilder.build();

        Assert.assertEquals("1.0", builded.getIds().get(0).getSV());
        Assert.assertEquals("x", builded.getIds().get(0).getValue());
        Assert.assertEquals("1.1", builded.getCds().get(0).getSV());
        Assert.assertEquals("x", builded.getCds().get(0).getValue());
    }

    /**
     * Test method for
     * {@link be.ehealth.business.kmehrcommons.builders.HcPartyBuilder#id(java.lang.String, be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes)}
     * .
     */
    @Test
    public void testMethodIDAndCd2() throws TechnicalConnectorException {
        HcPartyBuilder hcpBuilder = new HcPartyBuilder();
        hcpBuilder.id("1.0", "x", IDHCPARTYschemes.INSS).cd("1.1", "x", CDHCPARTYschemes.LOCAL, "1.2");
        HcpartyType builded = hcpBuilder.build();

        Assert.assertEquals("x", builded.getIds().get(0).getValue());
        Assert.assertEquals(IDHCPARTYschemes.INSS, builded.getIds().get(0).getS());
        Assert.assertEquals("1.1", builded.getCds().get(0).getSV());
        Assert.assertEquals("x", builded.getCds().get(0).getValue());
        Assert.assertEquals(CDHCPARTYschemes.LOCAL, builded.getCds().get(0).getS());
        Assert.assertEquals("1.2", builded.getCds().get(0).getSL());
    }

    /**
     * Test method for
     * {@link be.ehealth.business.kmehrcommons.builders.HcPartyBuilder#address(String, CDADDRESSschemes, String, String, String, String, String, String, String, String, String, CDCOUNTRYschemes, String)
     * 
     * @throws Exception 
     */
    @Test
    public void testMethodAddress() throws Exception {
        String expectedAddressCdValue = "test";
        CDADDRESSschemes expectedAddressCdSchemes = CDADDRESSschemes.CD_ADDRESS;
        String expectedAddressCdSv = "1.0";
        String expectedCity = "Bruxelles";
        String expectedZip = "1000";
        String expectedCountryValue = "Belgium";
        CDCOUNTRYschemes expectedCountrySchemes = CDCOUNTRYschemes.CD_COUNTRY;
        String expectedCountrySv = "1.0";

        HcPartyBuilder hcpBuilder = new HcPartyBuilder();
        hcpBuilder.id("1.0", "x", IDHCPARTYschemes.INSS).cd("1.1", "x", CDHCPARTYschemes.LOCAL, "1.2").address(expectedAddressCdValue, expectedAddressCdSchemes, expectedAddressCdSv, expectedCity, null, null, null, null, null, expectedZip, expectedCountryValue, expectedCountrySchemes, expectedCountrySv);
        HcpartyType builded = hcpBuilder.build();

        //Adress
        AddressType address = builded.getAddresses().get(0);
        Assert.assertEquals(expectedAddressCdValue,address.getCds().get(0).getValue());
        Assert.assertEquals(expectedAddressCdSchemes,address.getCds().get(0).getS());
        Assert.assertEquals(expectedAddressCdSv,address.getCds().get(0).getSV());
        Assert.assertEquals(expectedCity,address.getCity());
        Assert.assertEquals(expectedZip,address.getZip());
        Assert.assertEquals(expectedCountryValue,address.getCountry().getCd().getValue());
        Assert.assertEquals(expectedCountrySchemes,address.getCountry().getCd().getS());
        Assert.assertEquals(expectedCountrySv,address.getCountry().getCd().getSV());
    }
    
    /**
     * Test method without country for
     * {@link be.ehealth.business.kmehrcommons.builders.HcPartyBuilder#address(String, CDADDRESSschemes, String, String, String, String, String, String, String, String, String, CDCOUNTRYschemes, String)
     * 
     * @throws Exception 
     */
    @Test
    public void testMethodAddressNoCountry() throws Exception {
        String expectedAddressCdValue = "test";
        CDADDRESSschemes expectedAddressCdSchemes = CDADDRESSschemes.CD_ADDRESS;
        String expectedAddressCdSv = "1.0";
        HcPartyBuilder hcpBuilder = new HcPartyBuilder();
        hcpBuilder.id("1.0", "x", IDHCPARTYschemes.INSS).cd("1.1", "x", CDHCPARTYschemes.LOCAL, "1.2").address(expectedAddressCdValue, expectedAddressCdSchemes, expectedAddressCdSv, null, null, null, null, null, null, null, null, null, null);
        HcpartyType builded = hcpBuilder.build();

        //Adress
        AddressType address = builded.getAddresses().get(0);
        Assert.assertEquals(expectedAddressCdValue,address.getCds().get(0).getValue());
        Assert.assertEquals(expectedAddressCdSchemes,address.getCds().get(0).getS());
        Assert.assertEquals(expectedAddressCdSv,address.getCds().get(0).getSV());
        Assert.assertNull(address.getCountry());
    }
    
    /**
     * Test null parameters on
     * {@link be.ehealth.business.kmehrcommons.builders.HcPartyBuilder#address(String, CDADDRESSschemes, String, String, String, String, String, String, String, String, String, CDCOUNTRYschemes, String)
     * 
     * @throws Exception 
     */
    @Test (expected=IllegalArgumentException.class)
    public void testMethodAddressWithNullParam() throws Exception{
        HcPartyBuilder hcpBuilder = new HcPartyBuilder();
        hcpBuilder.address(null, null, null, null, null, null, null, null, null, null, null, null, null);
        hcpBuilder.build();
    }

}
