/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.intrahubcommons.security;

import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.handler.domain.RequestContext;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContextHandler
extends AbstractSOAPHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RequestContextHandler.class);
    private static final String MESSAGE_ENDPOINT_ADDRESS = "javax.xml.ws.service.endpoint.address";
    private String suffix = "";

    public RequestContextHandler() {
    }

    public RequestContextHandler(String suffix) {
        String input = suffix;
        if (!input.endsWith("_")) {
            input = input + "_";
        }
        this.suffix = input;
    }

    public boolean handleOutbound(SOAPMessageContext context) {
        try {
            SOAPMessage msg = context.getMessage();
            RequestContext reqContext = RequestContext.getInstance();
            reqContext.clear();
            String endPoint = (String)context.get((Object)MESSAGE_ENDPOINT_ADDRESS);
            if (endPoint != null && !endPoint.isEmpty()) {
                reqContext.put("endpoint", (Object)endPoint);
            }
            this.addToRequestContext(msg, reqContext, "OUT");
        }
        catch (SOAPException e) {
            LOG.error("SOAPException: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (IOException e) {
            LOG.error("IOException: {}", (Object)e.getMessage(), (Object)e);
        }
        return true;
    }

    public boolean handleInbound(SOAPMessageContext context) {
        try {
            SOAPMessage msg = context.getMessage();
            RequestContext reqContext = RequestContext.getInstance();
            this.addToRequestContext(msg, reqContext, "IN");
        }
        catch (SOAPException e) {
            LOG.error("SOAPException {}", (Object)e.getMessage(), (Object)e);
        }
        catch (IOException e) {
            LOG.error("IOException {}", (Object)e.getMessage(), (Object)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToRequestContext(SOAPMessage msg, RequestContext reqContext, String mode) throws SOAPException, IOException {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)out);
            reqContext.put("PAYLOAD_" + this.suffix + mode, (Object)out.toString(Charset.UTF_8.getName()));
            reqContext.put("SOAP_" + this.suffix + mode, (Object)msg);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)out);
        }
    }

    public boolean handleFault(SOAPMessageContext c) {
        this.handleMessage(c);
        return true;
    }
}

