/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.reader;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class CloseOnceReader<T extends Reader>
extends FilterReader {
    private int closeCount = 0;

    public CloseOnceReader(T source) {
        super((Reader)source);
        if (source == null) {
            throw new IllegalArgumentException("Source reader can't be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloseOnceReader closeOnceReader = this;
        synchronized (closeOnceReader) {
            ++this.closeCount;
            if (this.closeCount > 1) {
                return;
            }
        }
        this.in.close();
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public T getWrappedReader() {
        Reader result = this.in;
        return (T)result;
    }
}

