/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.SilentInstantiationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConfigurableImplementation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableFactoryHelper<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableFactoryHelper.class);
    private final Map<CacheKey, T> cache = new HashMap<CacheKey, T>();
    private final String classPropertyName;
    private final Configuration config;
    private final String defaultClassPropertyName;

    public ConfigurableFactoryHelper(String classPropertyName, String defaultClassPropertyName) {
        this.classPropertyName = classPropertyName;
        this.defaultClassPropertyName = defaultClassPropertyName;
        this.config = ConfigFactory.getConfigValidator();
    }

    @Deprecated
    public ConfigurableFactoryHelper(String classPropertyName, String defaultClassPropertyName, Class<T> clazz) {
        this(classPropertyName, defaultClassPropertyName);
    }

    private T createAndConfigureImplementation(String headerClassName, Map<String, Object> configParameters, boolean silent) throws TechnicalConnectorException {
        T result;
        try {
            result = this.createInstance(headerClassName);
            if (result != null) {
                this.init(result, configParameters, silent);
            }
        }
        catch (Exception e) {
            if (!silent) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.HEADER_INSTANCIATION, (Throwable)e, headerClassName);
            }
            return null;
        }
        return result;
    }

    private T createInstance(String headerClassName) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object providerObject;
        Class<?> provider = Class.forName(headerClassName);
        if (provider.getAnnotation(Deprecated.class) != null) {
            LOG.debug("Instantiating a deprecated class [{}], please verify the javadoc!", (Object)headerClassName);
        }
        try {
            providerObject = provider.newInstance();
        }
        catch (IllegalAccessException e) {
            LOG.debug("Default constructor is not public. Trying to invoke getInstance().");
            Method method = provider.getMethod("getInstance", new Class[0]);
            providerObject = method.invoke(provider, new Object[0]);
        }
        return (T)providerObject;
    }

    public T getImplementation() throws TechnicalConnectorException {
        return this.getImplementation(new HashMap<String, Object>(), true, false);
    }

    public T getImplementation(boolean useCache) throws TechnicalConnectorException {
        return this.getImplementation(new HashMap<String, Object>(), useCache, false);
    }

    public T getImplementation(Map<String, Object> configParameters) throws TechnicalConnectorException {
        return this.getImplementation(configParameters, true, false);
    }

    public T getImplementation(Map<String, Object> hashMap, boolean usecache) throws TechnicalConnectorException {
        return this.getImplementation(hashMap, usecache, false);
    }

    public T getImplementation(Map<String, Object> configParameters, boolean useCaching, boolean silent) throws TechnicalConnectorException {
        String headerClassName = this.config.getProperty(this.classPropertyName, this.defaultClassPropertyName);
        CacheKey cacheKey = new CacheKey(configParameters, headerClassName);
        if (useCaching && this.cache.containsKey(cacheKey)) {
            return this.cache.get(cacheKey);
        }
        if (headerClassName == null && !silent) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "No valid configuration " + this.classPropertyName + " not found.");
        }
        T result = this.getImplementation(headerClassName, configParameters, useCaching, silent);
        if (result == null && !silent) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "No valid configuration " + this.classPropertyName + " not found.");
        }
        return result;
    }

    private T getImplementation(String headerClassName, Map<String, Object> configParameters, boolean useCache, boolean silent) throws TechnicalConnectorException {
        CacheKey key = new CacheKey(configParameters, headerClassName);
        if (useCache && this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        if (headerClassName == null || headerClassName.isEmpty()) {
            return null;
        }
        T result = this.createAndConfigureImplementation(headerClassName, configParameters, silent);
        if (useCache) {
            this.cache.put(key, result);
        }
        return result;
    }

    public List<T> getImplementations() throws TechnicalConnectorException {
        return this.getImplementations(true);
    }

    public List<T> getImplementations(boolean useCache) throws TechnicalConnectorException {
        return this.getImplementations(useCache, true);
    }

    public List<T> getImplementations(boolean useCache, boolean silent) throws TechnicalConnectorException {
        return this.getImplementations(new HashMap<String, Object>(), useCache, silent);
    }

    public List<T> getImplementations(Map<String, Object> configParameters) throws TechnicalConnectorException {
        return this.getImplementations(configParameters, true);
    }

    public List<T> getImplementations(Map<String, Object> configParameters, boolean useCache) throws TechnicalConnectorException {
        return this.getImplementations(configParameters, useCache, true);
    }

    public List<T> getImplementations(Map<String, Object> configParameters, boolean useCache, boolean silent) throws TechnicalConnectorException {
        ArrayList<T> result = new ArrayList<T>();
        if (this.config.hasMatchingProperty(this.classPropertyName)) {
            List<String> headerClasses = this.config.getMatchingProperties(this.classPropertyName);
            for (String headerClassName : headerClasses) {
                T resultItem = this.getImplementation(headerClassName, configParameters, useCache, silent);
                if (resultItem == null) continue;
                result.add(resultItem);
            }
        } else {
            T resultItem = this.getImplementation(configParameters, useCache, silent);
            if (resultItem != null) {
                result.add(resultItem);
            }
        }
        return result;
    }

    private void init(T result, Map<String, Object> configParameters, boolean silent) throws TechnicalConnectorException {
        try {
            if (result instanceof ConfigurableImplementation) {
                if (configParameters == null) {
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, "addConfigParamsIfNeeded : parameter configParameters is null!");
                }
                ConfigurableImplementation resultAsConfigurable = (ConfigurableImplementation)result;
                resultAsConfigurable.initialize(configParameters);
            } else if (configParameters != null && !configParameters.isEmpty()) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, "non configurable implementation " + result.getClass() + " called with non empty configParameters : the class should implement the interface ConfigurableImplementation to use configParameters with the ConfigurableFactoryHelper!");
            }
        }
        catch (TechnicalConnectorException e) {
            if (!silent) {
                throw e;
            }
            throw new SilentInstantiationException(e);
        }
    }

    public void invalidateCache() {
        this.cache.clear();
    }

    private static class CacheKey {
        private final String className;
        private final Map<String, Object> configProperties;

        public CacheKey(Map<String, Object> configProperties, String className) {
            this.configProperties = configProperties;
            this.className = className;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            if (this.configProperties == null) {
                return other.configProperties == null;
            }
            return ((Object)this.configProperties).equals(other.configProperties);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.configProperties == null ? 0 : ((Object)this.configProperties).hashCode());
            return result;
        }
    }
}

