/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genericasync.builders.impl;

import be.cin.encrypted.EncryptedKnownContent;
import be.cin.nip.async.generic.GetResponse;
import be.cin.nip.async.generic.MsgResponse;
import be.cin.nip.async.generic.PostResponse;
import be.cin.nip.async.generic.TAck;
import be.cin.nip.async.generic.TAckResponse;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.mapper.DomainBlobMapper;
import be.ehealth.businessconnector.genericasync.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.genericasync.domain.ProcessedGetResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedMsgResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedTAckResponse;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncBusinessConnectorException;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncSignatureValidationConnectorException;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.ehealth.technicalconnector.validator.ValidatorHelper;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseObjectBuilderImpl
implements ResponseObjectBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseObjectBuilderImpl.class);
    public static final String GENERICASYNC = "genericasync.";
    private static Configuration config = ConfigFactory.getConfigValidator();

    @Override
    public final boolean handlePostResponse(PostResponse postResponse) throws GenAsyncBusinessConnectorException {
        if (postResponse == null || postResponse.getReturn() == null) {
            throw new GenAsyncBusinessConnectorException(GenAsyncBusinessConnectorExceptionValues.PARAMETER_NULL, "the postResponse or postResponse.return was null");
        }
        TAck tack = postResponse.getReturn();
        if (!tack.getResultMajor().equals("urn:nip:tack:result:major:success")) {
            throw new GenAsyncBusinessConnectorException(GenAsyncBusinessConnectorExceptionValues.SEND_REQUEST_FAILED, "message from tack -> " + tack.getResultMinor());
        }
        boolean hasWarning = false;
        if (tack.getResultMinor() != null && !tack.getResultMinor().isEmpty()) {
            hasWarning = true;
            LOG.info("handlePostResponse : warning : " + tack.getResultMinor());
            LOG.info("handlePostResponse : resultMessage  : " + tack.getResultMessage());
        }
        LOG.info("handlePostResponse : success : " + tack.getResultMajor());
        return hasWarning;
    }

    @Override
    public final Map<Object, SignatureVerificationResult> handleGetResponse(GetResponse getResponse) throws GenAsyncBusinessConnectorException {
        return this.handleGetResponse(getResponse, null);
    }

    @Override
    public final Map<Object, SignatureVerificationResult> handleGetResponse(GetResponse getResponse, String projectName) throws GenAsyncBusinessConnectorException {
        HashMap<Object, SignatureVerificationResult> validationResult = new HashMap<Object, SignatureVerificationResult>();
        for (TAckResponse value : getResponse.getReturn().getTAckResponses()) {
            LOG.debug("handleGetResponse : tackResponse : xades : " + value.getXadesT() + ", tack : " + value.getTAck());
            validationResult.putAll(this.validateXadesT(value, value.getXadesT().getValue()));
        }
        for (MsgResponse msgResponse : getResponse.getReturn().getMsgResponses()) {
            if (msgResponse.getXadesT() == null) continue;
            validationResult.putAll(this.validateXadesT(msgResponse, msgResponse.getXadesT().getValue()));
        }
        if (!validationResult.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                this.logValidationResult(validationResult);
            }
            throw new GenAsyncSignatureValidationConnectorException(GenAsyncBusinessConnectorExceptionValues.SIGNATURE_VALIDATION_ERROR, validationResult);
        }
        return validationResult;
    }

    @Override
    public <T> ProcessedGetResponse processResponse(GetResponse getResponse, Class<T> clazz, String projectName, String schemaLocation) throws GenAsyncBusinessConnectorException, TechnicalConnectorException {
        ProcessedGetResponse processedGetResponse = new ProcessedGetResponse();
        for (TAckResponse value : getResponse.getReturn().getTAckResponses()) {
            LOG.debug("handleGetResponse : tackResponse : xades : " + value.getXadesT() + ", tack : " + value.getTAck());
            ProcessedTAckResponse tAckResponse = new ProcessedTAckResponse(value, this.validateTAckXadesT(value, value.getXadesT().getValue(), projectName));
            processedGetResponse.getTAckResponses().add(tAckResponse);
        }
        for (MsgResponse msgResponse : getResponse.getReturn().getMsgResponses()) {
            ProcessedMsgResponse<T> processedMsgResponse;
            if (msgResponse.getDetail().getContentEncryption() == null) {
                byte[] unwrappedMessageByteArray = this.getContent(msgResponse, projectName);
                LOG.debug("Content of decrypted business message:[{}]", (Object)ConnectorIOUtils.toString((byte[])unwrappedMessageByteArray, (Charset)Charset.UTF_8));
                processedMsgResponse = new ProcessedMsgResponse<T>(msgResponse, this.toBusinessResponse(clazz, unwrappedMessageByteArray), this.validateMsgXadesT(msgResponse, msgResponse.getXadesT().getValue(), projectName), ArrayUtils.isEmpty((byte[])msgResponse.getXadesT().getValue()) ? null : unwrappedMessageByteArray);
            } else {
                processedMsgResponse = this.processEncryptedResponse(msgResponse, projectName, clazz);
            }
            processedGetResponse.getMsgResponses().add(processedMsgResponse);
            if (schemaLocation == null || !config.getBooleanProperty(GENERICASYNC + projectName + ".validation.incoming.businessresponse", Boolean.valueOf(true)).booleanValue()) continue;
            ValidatorHelper.validate(processedMsgResponse.getBusinessResponse(), (String)schemaLocation);
        }
        return processedGetResponse;
    }

    @Override
    public <T> ProcessedMsgResponse<T> processEncryptedResponse(MsgResponse msgResponse, String projectName, Class<T> clazz) throws TechnicalConnectorException, GenAsyncBusinessConnectorException {
        LOG.debug("Analysing msgResponse {}", (Object)ConnectorXmlUtils.toString((Object)msgResponse));
        byte[] unwrappedMessageByteArray = this.getContent(msgResponse, projectName);
        byte[] unsealedData = SessionUtil.getHolderOfKeyCrypto().unseal(Crypto.SigningPolicySelector.WITHOUT_NON_REPUDIATION, unwrappedMessageByteArray).getContentAsByte();
        LOG.debug("Unsealed data [{}].", (Object)new String(unsealedData));
        EncryptedKnownContent encryptedKnownContent = (EncryptedKnownContent)ConnectorXmlUtils.toObject((byte[])unsealedData, EncryptedKnownContent.class);
        byte[] decryptedMessageByteArray = "deflate".equals(encryptedKnownContent.getBusinessContent().getContentEncoding()) ? ConnectorIOUtils.decompress((byte[])encryptedKnownContent.getBusinessContent().getValue()) : encryptedKnownContent.getBusinessContent().getValue();
        LOG.debug("Content of decrypted business message:[{}]", (Object)ConnectorIOUtils.toString((byte[])decryptedMessageByteArray, (Charset)Charset.UTF_8));
        ProcessedMsgResponse<T> processedMsgResponse = new ProcessedMsgResponse<T>(msgResponse, this.toBusinessResponse(clazz, decryptedMessageByteArray), encryptedKnownContent, this.validateMsgXadesT(encryptedKnownContent, encryptedKnownContent.getXades(), projectName), ArrayUtils.isEmpty((byte[])encryptedKnownContent.getXades()) ? null : unsealedData);
        return processedMsgResponse;
    }

    private <T> T toBusinessResponse(Class<T> clazz, byte[] unwrappedMessageByteArray) {
        return (T)(clazz.equals(byte[].class) ? unwrappedMessageByteArray : (byte[])ConnectorXmlUtils.toObject((byte[])unwrappedMessageByteArray, clazz));
    }

    public byte[] getContent(MsgResponse msgResponse, String projectName) throws TechnicalConnectorException {
        Blob mappedBlob = DomainBlobMapper.mapToBlob((be.cin.types.v1.Blob)msgResponse.getDetail());
        mappedBlob.setHashTagRequired(config.getBooleanProperty("genericasync" + projectName + ".hashtagrequired", Boolean.valueOf(false)).booleanValue());
        return BlobBuilderFactory.getBlobBuilder((String)"genericasync").checkAndRetrieveContent(mappedBlob);
    }

    private SignatureVerificationResult validateXadesT(Object value, byte[] xadesT, boolean followNestedManifest) throws GenAsyncBusinessConnectorException {
        if (!ArrayUtils.isEmpty((byte[])xadesT)) {
            byte[] signedByteArray = ConnectorXmlUtils.toByteArray((Object)value);
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("followNestedManifest", followNestedManifest);
            try {
                return SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES_T).verify(signedByteArray, xadesT, options);
            }
            catch (TechnicalConnectorException e) {
                throw new GenAsyncBusinessConnectorException(GenAsyncBusinessConnectorExceptionValues.SIGNATURE_VALIDATION_ERROR, e, e.getMessage());
            }
        }
        return null;
    }

    @Override
    public SignatureVerificationResult validateTAckXadesT(Object value, byte[] xadesT, String projectName) throws GenAsyncBusinessConnectorException {
        return this.validateXadesT(value, xadesT, projectName == null ? false : config.getBooleanProperty("GENERICASYNC" + projectName + ".validation.xades.tack.follownestedmanifest", Boolean.valueOf(false)));
    }

    @Override
    public SignatureVerificationResult validateMsgXadesT(Object value, byte[] xadesT, String projectName) throws GenAsyncBusinessConnectorException {
        return this.validateXadesT(value, xadesT, projectName == null ? false : config.getBooleanProperty("GENERICASYNC" + projectName + ".validation.xades.msg.follownestedmanifest", Boolean.valueOf(false)));
    }

    private void logValidationResult(Map<Object, SignatureVerificationResult> validationResults) {
        LOG.debug("validationResults : -------------------------");
        for (Object key : validationResults.keySet()) {
            SignatureVerificationResult signatureVerificationResult = validationResults.get(key);
            StringBuilder errorsSb = new StringBuilder();
            for (SignatureVerificationError error : signatureVerificationResult.getErrors()) {
                errorsSb.append(error).append(" ");
            }
            LOG.debug("key : " + key + "\t" + " validationResult errors : " + errorsSb.toString());
        }
        LOG.debug("--------------------------------------");
    }

    private Map<Object, SignatureVerificationResult> validateXadesT(Object value, byte[] xadesT) throws GenAsyncBusinessConnectorException {
        HashMap<Object, SignatureVerificationResult> vResult = new HashMap<Object, SignatureVerificationResult>();
        if (!ArrayUtils.isEmpty((byte[])xadesT)) {
            byte[] signedByteArray = ConnectorXmlUtils.toByteArray((Object)value);
            HashMap options = new HashMap();
            try {
                SignatureVerificationResult result = SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES_T).verify(signedByteArray, xadesT, options);
                if (!result.isValid()) {
                    vResult.put(value, result);
                }
            }
            catch (TechnicalConnectorException e) {
                throw new GenAsyncBusinessConnectorException(GenAsyncBusinessConnectorExceptionValues.SIGNATURE_VALIDATION_ERROR, e, e.getMessage());
            }
        }
        return vResult;
    }

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
    }
}

