﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.util;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.mappers;
using be.ehealth.businessconnector.genericasync.test.helper;
using be.ehealth.technicalconnector.config.util;
using be.ehealth.technicalconnector.config.util.domain;
using be.ehealth.technicalconnector.handler.domain;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using java.io;
using java.util;
using java.net;
using org.apache.commons.lang;
using NUnit.Framework;
using be.cin.mycarenet.esb.common.v2;
using be.cin.nip.async.generic;
using be.ehealth.businessconnector.genericasync.session;
using org.slf4j;

using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.business.mycarenetdomaincommons.mapper;
using be.ehealth.businessconnector.genericasync.domain;

namespace be.ehealth.businessconnector.geninsasync.session
{

	[TestFixture]
	public class GenInsPostInvoicingGenericAsyncIntegrationTest
	{
		private static Logger LOG = LoggerFactory.getLogger(typeof(GenInsPostInvoicingGenericAsyncIntegrationTest));
		
		private static string PROJECT_NAME = "genins";
		private static string XML_REQUEST_FOLDER = ".\\examples\\genins\\async\\";
        private static string MESSAGE_NAME = "INSX";

        private static PostTestHelper testHelper;

    
		[SetUp]
	    public static void init() {
	    	SessionInitializer.init(".\\be.ehealth.businessconnector.geninsasync.test.properties",SupportedLanguages.NET.getAbbreviation());
	    	testHelper = PostTestHelper.builder().withProjectName(PROJECT_NAME).hasXades(false).isTest(false).build();
		}
	
	    [TearDown]
	    public static void tearDown() {
	        Session.getInstance().unloadSession();
	    }
                
	    static object[] testCase =
      {
          new Object[]{"OA100"},
          new Object[]{"OA300"},
          new Object[]{"OA500"},
          new Object[]{"OA600"},
          new Object[]{"OA900"}
        };
	    
	  [Test, TestCaseSource("testCase")]
          public void performPostRequestTest(String oa) {
              performPost(ConnectorIOUtils.getResourceAsByteArray(XML_REQUEST_FOLDER + "ValidRequest_" + oa + ".xml"),
                      PROJECT_NAME,
                      MESSAGE_NAME);
          }
      
	  [Test, TestCaseSource("testCase")]
      public void performPosRequestTest(String oa) {
          performPost(ConnectorIOUtils.getResourceAsByteArray(XML_REQUEST_FOLDER + "InvalidRequestPeriod_" + oa + ".xml"),
                  PROJECT_NAME,
                  MESSAGE_NAME);
      }
      
      
      public void performPost(byte[] contentBytes, string serviceName, string messageName) {
          Post post = testHelper.buildPostRequest(contentBytes, messageName);
          PostResponse responsePost = testHelper.post(serviceName, post);
          testHelper.validateResponse(responsePost);
      }
	}
}
