package be.ehealth.technicalconnector.ws;

import java.io.IOException;
import java.util.Properties;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * The Class GenericWsUnsecuredITTest.
 * 
 * @author EHP
 */
public class GenericWsUnsecuredIntegrationTest {

    private static Properties config;

    @SuppressWarnings("javadoc")
    @BeforeClass
    public static void init() throws Exception {
        config = TestPropertiesLoader.getProperties("/be.ehealth.technicalconnector.test.properties");
    }

    /**
     * Invoke the check Connection method on the Platform Integration Test
     * 
     * This test includes the following main steps: <li>1. Set the URL to the web service end-point <li>2. Get the payload <li>3. Send the
     * message
     */
    @Test
    public void testSendUnsecured() throws Exception {
        Assert.assertNotNull(invoke().asString());
    }

    /**
     * Invoke the check Connection method on the Platform Integration Test
     * 
     * This test includes the following main steps: <li>1. Set the URL to the web service end-point <li>2. Get the payload <li>3. Send the
     * message
     */
    @Test
    public void testSendUnsecuredDOM() throws Exception {
        Assert.assertNotNull(invoke().asNode());
    }

    private GenericResponse invoke() throws Exception {
        GenericRequest request = new GenericRequest();
        request.setPayload(getPayload());
        request.setEndpoint(config.getProperty("test.unsecured.endpoint"));
        request.setDefaultHandlerChain();

        return be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender()
                                                              .send(request);
    }

    /**
     * Builds the payload (string) for the request.
     */
    private String getPayload() throws IOException, TechnicalConnectorException {
        StringBuilder sb = new StringBuilder();
        sb.append("<CheckConnectionRequest xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:v1\">");
        sb.append("<Message xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">Hello this is your captain speeking</Message>");
        sb.append("<Timestamp xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">");
        sb.append(DateUtils.printDateTime(new DateTime()));
        sb.append("</Timestamp>");
        sb.append("</CheckConnectionRequest>");
        return sb.toString();

    }


}
