/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.therlink.service.impl;


import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.businessconnector.therlink.builders.CommonObjectBuilder;
import be.ehealth.businessconnector.therlink.builders.ProofBuilder;
import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.therlink.domain.TherapeuticLink;
import be.ehealth.businessconnector.therlink.domain.requests.RevokeTherapeuticLinkRequest;
import be.ehealth.businessconnector.therlink.domain.responses.RevokeTherapeuticLinkResponse;
import be.ehealth.businessconnector.therlink.exception.TherLinkBusinessConnectorException;
import be.ehealth.businessconnector.therlink.mappers.MapperFactory;
import be.ehealth.businessconnector.therlink.mappers.RequestObjectMapper;
import be.ehealth.businessconnector.therlink.mappers.ResponseObjectMapper;
import be.ehealth.businessconnector.therlink.service.ServiceFactory;
import be.ehealth.businessconnector.therlink.service.TherLinkService;
import be.ehealth.businessconnector.test.therlink.util.TestConstants;
import be.ehealth.businessconnector.test.therlink.util.TherlinkTestUtils;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;

/**
 * Integration tests superclass which will remove therapeutic links that needs to be cleared
 * 
 * @author EH065
 * 
 */
public abstract class AbstractTherlinkIsolationIntegrationTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTherlinkIsolationIntegrationTest.class);

    protected static TherLinkService therlinkWS = ServiceFactory.getTherLinkService();


    protected static CommonObjectBuilder commonBuilder;

    protected static RequestObjectBuilder requestObjectBuilder;

    protected static RequestObjectMapper requestObjectMapper;

    protected static ProofBuilder proofBuilder;

    protected static ResponseObjectMapper responseObjectMapper;

    public AbstractTherlinkIsolationIntegrationTest() throws TherLinkBusinessConnectorException, TechnicalConnectorException, InstantiationException {
        super();
        commonBuilder = RequestObjectBuilderFactory.getCommonBuilder();
        proofBuilder = RequestObjectBuilderFactory.getProofBuilder();
        requestObjectBuilder = RequestObjectBuilderFactory.getRequestObjectBuilder();
        responseObjectMapper = MapperFactory.getResponseObjectMapper();
        requestObjectMapper = MapperFactory.getRequestObjectMapper();
    }

    @BeforeClass
    public static void initSession() throws Exception {
        SessionInitializer.init(TestConstants.THERLINK_TEST_PROPERTIES);
    }


    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    /**
     * Revoke a therapeutic link using an Eid signing proof
     * 
     */
    protected void revokeLinkWithEidSigningProof(TherapeuticLink link) throws TechnicalConnectorException, TherLinkBusinessConnectorException, InstantiationException {
        RevokeTherapeuticLinkRequest createRevokeTherapeuticLinkRequest = requestObjectBuilder.createRevokeTherapeuticLinkRequestWithProof(link, proofBuilder.createProofForEidReading());
        SAMLToken samlToken = Session.getInstance().getSession().getSAMLToken();

        be.fgov.ehealth.hubservices.core.v2.RevokeTherapeuticLinkResponse revokeTherapeuticLinkResponse = therlinkWS.revokeTherapeuticLink(samlToken, requestObjectMapper.mapRevokeTherapeuticLinkRequest(createRevokeTherapeuticLinkRequest));
        RevokeTherapeuticLinkResponse mappedRevokeResponse = responseObjectMapper.mapJaxbToRevokeTherapeuticLinkResponse(revokeTherapeuticLinkResponse);

        if (mappedRevokeResponse.getAcknowledge().isComplete()) {
            LOGGER.info(">>> Therapeutic link revoked");
        } else {
            TherlinkTestUtils.extractAndAssertErrorMessage(mappedRevokeResponse.getAcknowledge(), null);
        }
    }

    /**
     * Revoke the link
     */
    protected void revokeLink(TherapeuticLink link) throws TechnicalConnectorException, TherLinkBusinessConnectorException, InstantiationException {
        SAMLToken samlToken = Session.getInstance().getSession().getSAMLToken();

        RevokeTherapeuticLinkRequest createRevokeTherapeuticLinkRequest = requestObjectBuilder.createRevokeTherapeuticLinkRequest(link);

        be.fgov.ehealth.hubservices.core.v2.RevokeTherapeuticLinkResponse revokeTherapeuticLinkResponse = therlinkWS.revokeTherapeuticLink(samlToken, requestObjectMapper.mapRevokeTherapeuticLinkRequest(createRevokeTherapeuticLinkRequest));
        RevokeTherapeuticLinkResponse revokeResponse = responseObjectMapper.mapJaxbToRevokeTherapeuticLinkResponse(revokeTherapeuticLinkResponse);

        if (revokeResponse.getAcknowledge().isComplete()) {
            LOGGER.info(">>> Therapeutic link revoked");
        } else {
            TherlinkTestUtils.extractAndAssertErrorMessage(revokeResponse.getAcknowledge(), null);
        }
    }


}