/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.hubv3.helpers;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.hubservices.core.v3.ConsentType;
import be.fgov.ehealth.hubservices.core.v3.HCPartyIdType;
import be.fgov.ehealth.hubservices.core.v3.PatientIdType;
import be.fgov.ehealth.hubservices.core.v3.TherapeuticLinkType;
import be.fgov.ehealth.hubservices.core.v3.TransactionWithPeriodType;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONSENT;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONSENTschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONSENTvalues;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTHERAPEUTICLINK;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTHERAPEUTICLINKschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTRANSACTION;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTRANSACTIONschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENT;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENTschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.AuthorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import org.joda.time.DateTime;

/**
 * @author EHP
 */
public class OrgPharmacyHubTestHelper {

    private static final Configuration config = ConfigFactory.getConfigValidator();

    private Patient testPatient;

    public OrgPharmacyHubTestHelper(Patient testPatient) {
        this.testPatient = testPatient;
    }

    /**
     * Create an IDPATIENT for Niss
     */
    private IDPATIENT createIdPatientInss() {
        IDPATIENT idPatient = new IDPATIENT();
        idPatient.setS(IDPATIENTschemes.INSS);
        idPatient.setSV("1.0");
        idPatient.setValue(testPatient.getInss());
        return idPatient;
    }

    /**
     * Create an IDPATIENT for Niss
     */
    private IDPATIENT createIdPatientCardno() {
        IDPATIENT idPatient = new IDPATIENT();
        idPatient.setS(IDPATIENTschemes.EID_CARDNO);
        idPatient.setSV("1.0");
        idPatient.setValue(testPatient.getEidCardNumber());
        return idPatient;
    }
    
    /**
     * Create a PatientIdType Used by createConsentType
     */
    public PatientIdType createPatientIdType() {
        PatientIdType patient = new PatientIdType();
        IDPATIENT idPatient = createIdPatientInss();
        patient.getIds().add(idPatient);
        if (this.testPatient.getEidCardNumber() != null) {
            IDPATIENT idPatientCardNo = createIdPatientCardno();
            patient.getIds().add(idPatientCardNo);
        }
        return patient;
    }
    
    /**
     * Create the author of the operation
     */
    public AuthorType createAuthor() {
        AuthorType author = new AuthorType();
        HcpartyType hcParty = new HcpartyType();
        CDHCPARTY cdHcParty = new CDHCPARTY();
        cdHcParty.setS(CDHCPARTYschemes.CD_HCPARTY);
        cdHcParty.setSV("1.1");
        cdHcParty.setValue("orgpharmacy");
        hcParty.getCds().add(cdHcParty);
        IDHCPARTY idHcparty = new IDHCPARTY();
        idHcparty.setS(IDHCPARTYschemes.ID_HCPARTY);
        idHcparty.setSV("1.1");
        idHcparty.setValue("34240406");
        hcParty.getIds().add(idHcparty);

        HcpartyType hcParty1 = new HcpartyType();
        hcParty1.setFamilyname("Ann");
        hcParty1.setFirstname("Vercruysse");
        CDHCPARTY cdHcParty1 = new CDHCPARTY();
        cdHcParty1.setS(CDHCPARTYschemes.CD_HCPARTY);
        cdHcParty1.setSV("1.1");
        cdHcParty1.setValue("perspharmacist");
        hcParty1.getCds().add(cdHcParty1);
        IDHCPARTY idHcparty1 = new IDHCPARTY();
        idHcparty1.setS(IDHCPARTYschemes.ID_HCPARTY);
        idHcparty1.setSV("1.0");
        idHcparty1.setValue("21462635001");
        IDHCPARTY idHcparty11 = new IDHCPARTY();
        idHcparty11.setS(IDHCPARTYschemes.INSS);
        idHcparty11.setSV("1.0");
        idHcparty11.setValue("75040307481");
        hcParty1.getIds().add(idHcparty1);
        hcParty1.getIds().add(idHcparty11);
        
        HcpartyType hcParty2 = new HcpartyType();
        hcParty2.setFamilyname("Hannes");
        hcParty2.setFirstname("De Clercq");
        CDHCPARTY cdHcParty2 = new CDHCPARTY();
        cdHcParty2.setS(CDHCPARTYschemes.CD_HCPARTY);
        cdHcParty2.setSV("1.1");
        cdHcParty2.setValue("perspharmacist");
        hcParty2.getCds().add(cdHcParty2);
        IDHCPARTY idHcparty2 = new IDHCPARTY();
        idHcparty2.setS(IDHCPARTYschemes.ID_HCPARTY);
        idHcparty2.setSV("1.0");
        idHcparty2.setValue("29001416001");
        IDHCPARTY idHcparty22 = new IDHCPARTY();
        idHcparty22.setS(IDHCPARTYschemes.INSS);
        idHcparty22.setSV("1.0");
        idHcparty22.setValue("82051234978");
        hcParty2.getIds().add(idHcparty2);
        hcParty2.getIds().add(idHcparty22);
        
        author.getHcparties().add(hcParty);
        author.getHcparties().add(hcParty1);
        author.getHcparties().add(hcParty2);

        return author;
    }

    /**
     * Create a consentType used for consent operations
     */
    public ConsentType createConsentType() {
        ConsentType consent = new ConsentType();

        CDCONSENT cdConsent = new CDCONSENT();
        cdConsent.setS(CDCONSENTschemes.CD_CONSENTTYPE);
        cdConsent.setSV("1.0");
        cdConsent.setValue(CDCONSENTvalues.RETROSPECTIVE);
        consent.getCds().add(cdConsent);

        consent.setAuthor(createAuthor());
        consent.setPatient(createPatientIdType());
        consent.setSigndate(new DateTime());

        return consent;
    }

    /**
     * Create a TherapeuticLinkType used for ther link operations
     */
    public TherapeuticLinkType createTherapeuticLinkType() throws TechnicalConnectorException {
        TherapeuticLinkType therapeuticLink = new TherapeuticLinkType();

        CDTHERAPEUTICLINK cdTherLink = new CDTHERAPEUTICLINK();
        cdTherLink.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
        cdTherLink.setSV("1.0");
        cdTherLink.setValue("pharmacydelivery");
        therapeuticLink.setCd(cdTherLink);

        HCPartyIdType hcParty = new HCPartyIdType();
        
        IDHCPARTY idHcparty = new IDHCPARTY();
        idHcparty.setS(IDHCPARTYschemes.ID_HCPARTY);
        idHcparty.setSV("1.1");
        idHcparty.setValue("34240406");
        hcParty.getIds().add(idHcparty);
        IDHCPARTY idHcparty1 = new IDHCPARTY();
        idHcparty1.setS(IDHCPARTYschemes.ID_HCPARTY);
        idHcparty1.setSV("1.0");
        idHcparty1.setValue("21462635001");
        IDHCPARTY idHcparty11 = new IDHCPARTY();
        idHcparty11.setS(IDHCPARTYschemes.INSS);
        idHcparty11.setSV("1.0");
        idHcparty11.setValue("75040307481");

        IDHCPARTY idHcparty2 = new IDHCPARTY();
        idHcparty2.setS(IDHCPARTYschemes.ID_HCPARTY);
        idHcparty2.setSV("1.0");
        idHcparty2.setValue("29001416001");
        IDHCPARTY idHcparty22 = new IDHCPARTY();
        idHcparty22.setS(IDHCPARTYschemes.INSS);
        idHcparty22.setSV("1.0");
        idHcparty22.setValue("82051234978");
        hcParty.getIds().add(idHcparty);
        
        therapeuticLink.setHcparty(hcParty);
        therapeuticLink.setPatient(createPatientIdType());
        therapeuticLink.setStartdate(new DateTime());
        return therapeuticLink;
    }

    public TransactionWithPeriodType createMedicationSchemeSearchTransaction() {
        TransactionWithPeriodType transaction = new TransactionWithPeriodType();
        CDTRANSACTION cdtransactionMedicationScheme = getCdtransaction("1.6", "medicationscheme");
        transaction.getCds().add(cdtransactionMedicationScheme);
        return transaction;
    }

    private CDTRANSACTION getCdtransaction(String value, String transactionType) {
        CDTRANSACTION cdtransactionMedicationScheme = new CDTRANSACTION();
        cdtransactionMedicationScheme.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
        cdtransactionMedicationScheme.setSV(value);
        cdtransactionMedicationScheme.setValue(transactionType);
        return cdtransactionMedicationScheme;
    }
}
