/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.hub.session;

import be.ehealth.business.intrahubcommons.exception.IntraHubBusinessConnectorException;
import be.ehealth.business.test.kmehrcommons.helper.ErrorTypeManagement;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.hubservices.core.v1.ConsentType;
import be.fgov.ehealth.hubservices.core.v1.GetTherapeuticLinkResponse;
import be.fgov.ehealth.hubservices.core.v1.PutTherapeuticLinkResponse;
import be.fgov.ehealth.hubservices.core.v1.RevokeTherapeuticLinkResponse;
import be.fgov.ehealth.hubservices.core.v1.SelectGetHCPartyPatientConsentType;
import be.fgov.ehealth.hubservices.core.v1.TherapeuticLinkType;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTHERAPEUTICLINK;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTHERAPEUTICLINKschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import java.util.List;


/**
 * Test on the therapeutic link operations
 * 
 * @author EH054
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class TherLinkIntegrationTest extends AbstractIntrahubIntegrationTest {

    private static ConsentType consent;

    @BeforeClass
    public static void initConsent() throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        consent = HubTestHelper.createConsentType();
        hubServiceComplete.putPatientConsent(consent);
    }

    @AfterClass
    public static void teardownConsent() throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        consent.setRevokedate(new DateTime());
        hubServiceComplete.revokePatientConsent(consent);
    }

    /**
     * PutTherapeuticLink operation
     */
    @Test
    public void _00_putTherapeuticLink() throws Exception {
        TherapeuticLinkType therapeuticLink = HubTestHelper.createTherapeuticLinkType();
        PutTherapeuticLinkResponse putTherapeuticLink = hubServiceComplete.putTherapeuticLink(therapeuticLink);
        therapeuticLink.setEnddate(new DateTime());
        hubServiceComplete.revokeTherapeuticLink(therapeuticLink);

        List<ErrorType> errors = putTherapeuticLink.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }

    /**
     * GetTherapeuticLink operation
     */
    @Test
    public void _01_getTherapeuticLink() throws Exception {
        TherapeuticLinkType therapeuticLink = HubTestHelper.createTherapeuticLinkType();
        hubServiceComplete.putTherapeuticLink(therapeuticLink);

        GetTherapeuticLinkResponse getResponse = hubServiceComplete.getTherapeuticLink(createSelectGetHCPartyPatientConsentType());

        therapeuticLink.setEnddate(new DateTime());
        hubServiceComplete.revokeTherapeuticLink(therapeuticLink);

        List<ErrorType> errors = getResponse.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }

    /**
     * RevokeTherapeuticLink operation
     */
    @Test
    public void _02_revokeTherapeuticLink() throws Exception {
        TherapeuticLinkType therapeuticLink = HubTestHelper.createTherapeuticLinkType();
        hubServiceComplete.putTherapeuticLink(therapeuticLink);

        therapeuticLink.setEnddate(new DateTime());
        RevokeTherapeuticLinkResponse revokeTherapeuticLink = hubServiceComplete.revokeTherapeuticLink(therapeuticLink);

        List<ErrorType> errors = revokeTherapeuticLink.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }

    /**
     * Create a SelectGetHCPartyPatientConsentType used for ther link operations
     */
    private SelectGetHCPartyPatientConsentType createSelectGetHCPartyPatientConsentType() throws TechnicalConnectorException {
        SelectGetHCPartyPatientConsentType selectConsent = new SelectGetHCPartyPatientConsentType();

        CDTHERAPEUTICLINK cdTherLink = new CDTHERAPEUTICLINK();
        cdTherLink.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
        cdTherLink.setSV(HubConfig.SV_CD);
        cdTherLink.setValue("gpconsultation");
        selectConsent.getCds().add(cdTherLink);

        selectConsent.getPatientsAndHcparties().add(HubTestHelper.createPatientIdType());
        selectConsent.getPatientsAndHcparties().add(HubTestHelper.createHcPartyIdProfessional());
        selectConsent.setBegindate(new DateTime());
        selectConsent.setEnddate(new DateTime());

        return selectConsent;
    }
}
