/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.Arrays;
import org.mockserver.matchers.BodyMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryMatcher
extends BodyMatcher<byte[]> {
    private static Logger logger = LoggerFactory.getLogger(BinaryMatcher.class);
    private final byte[] matcher;

    public BinaryMatcher(byte[] matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(byte[] matched) {
        boolean result = false;
        if (this.matcher == null || this.matcher.length == 0 || Arrays.equals(this.matcher, matched)) {
            result = true;
        }
        if (!result) {
            logger.trace("Failed to perform binary match [{}] with [{}] because {}", (Object)matched);
        }
        return this.reverseResultIfNot(result);
    }

    @Override
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger"};
    }
}

