/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdentifierType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final IdentifierType CBE;
    public static final IdentifierType CBE_TREATCENTER;
    public static final IdentifierType SSIN;
    public static final IdentifierType NIHII;
    public static final IdentifierType NIHII11;
    public static final IdentifierType NIHII_PHARMACY;
    public static final IdentifierType NIHII_LABO;
    public static final IdentifierType NIHII_RETIREMENT;
    public static final IdentifierType NIHII_OTD_PHARMACY;
    public static final IdentifierType NIHII_HOSPITAL;
    public static final IdentifierType NIHII_GROUPOFNURSES;
    public static final IdentifierType EHP;
    public static final IdentifierType NIHII_PALLIATIVE_CARE;
    public static final IdentifierType NIHII_OFFICE_DENTISTS;
    public static final IdentifierType NIHII_MEDICAL_HOUSE;
    public static final IdentifierType NIHII_OFFICE_DOCTORS;
    public static final IdentifierType NIHII_GROUP_DOCTORS;
    public static final IdentifierType NIHII_OF_BAND;
    public static final IdentifierType NIHII_PSYCH_HOUSE;
    public static final IdentifierType NIHII_PROT_ACC;
    public static final IdentifierType NIHII_HOME_SERVICES;
    public static final IdentifierType NIHII_OF_PHYSIOS;
    public static final IdentifierType SITE;
    public static final IdentifierType SITESMUR;
    public static final IdentifierType SITEPIT;
    public static final IdentifierType CBE_CONSORTIUM;
    public static final IdentifierType NIHII_GUARD_POST;
    public static final IdentifierType EHP_CTRL_ORGANISM;
    public static final IdentifierType NIHII_BELRAI;
    public static final IdentifierType NIHII_BELRAI_SCREEN;
    public static final IdentifierType NIHII_GROUP_MIDWIVES;
    public static final IdentifierType NIHII_AMBU_SERVICE;
    public static final IdentifierType NIHII_LEGAL_PSY;
    public static final IdentifierType NIHII_REEDUCATION;
    public static final IdentifierType NIHII_SORTING_CENTER;
    @Deprecated
    public static final IdentifierType HUB;
    public static final int ETKDEPOT = 48;
    public static final int EHBOX = 49;
    @Deprecated
    public static final int EHBOXV2 = 49;
    public static final int RECIPE = 50;
    private static final Logger LOG;
    private static final int EXPECTED_SIZE_MAPPING = 3;
    private String typeEtk;
    private String typeEhbox;
    private String typeRecipe;
    private int length;
    private static Map<String, IdentifierType> predefinedTypes;

    private IdentifierType(String type, int length) {
        this.typeEtk = type;
        this.typeEhbox = type;
        this.typeRecipe = type;
        this.length = length;
    }

    private IdentifierType(String typeEtk, String typeEhboxv2, String typeRecipe, int length) {
        this.typeEtk = typeEtk;
        this.typeEhbox = typeEhboxv2;
        this.typeRecipe = typeRecipe;
        this.length = length;
    }

    public static IdentifierType getInstance(Map<Integer, String> mapping, int expectedLength) throws TechnicalConnectorException {
        if (mapping == null) {
            TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.INVALID_MAPPING;
            LOG.debug("\t## {}", (Object)MessageFormat.format(errorValue.getMessage(), "mapping is empty"));
            throw new TechnicalConnectorException(errorValue, "mapping is empty");
        }
        String typeETK = mapping.get(48);
        String typeEhbox = mapping.get(49);
        String typeRecipe = mapping.get(50);
        int actualMapSize = mapping.size();
        IdentifierType.validateMapping(typeETK, typeEhbox, typeRecipe, actualMapSize);
        return IdentifierType.getIdentifierType(typeETK, typeEhbox, typeRecipe, expectedLength);
    }

    private static IdentifierType getIdentifierType(String typeETK, String typeEhbox, String typeRecipe, int expectedLength) throws TechnicalConnectorException {
        Map<Integer, IdentifierType> identifierTypes = IdentifierType.lookup(typeETK, typeEhbox, typeRecipe);
        if (identifierTypes.isEmpty()) {
            LOG.info("Adding identifier with null values.");
            IdentifierType identifier = new IdentifierType(typeETK, typeEhbox, typeRecipe, expectedLength);
            predefinedTypes.put(typeETK.replace("-", "_"), identifier);
            return identifier;
        }
        if (!identifierTypes.containsKey(49) || !identifierTypes.containsKey(48)) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_MAPPING, "Required Fields are empty.");
        }
        if (identifierTypes.get(48).equals(identifierTypes.get(49)) && (!identifierTypes.containsKey(50) || identifierTypes.get(48).equals(identifierTypes.get(50)))) {
            return identifierTypes.get(48);
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_MAPPING, "Multiple IdentifierTypes matches the mapping.");
    }

    private static Map<Integer, IdentifierType> lookup(String typeETK, String typeEhbox, String typeRecipe) {
        HashMap<Integer, IdentifierType> result = new HashMap<Integer, IdentifierType>();
        for (IdentifierType identifier : predefinedTypes.values()) {
            if (identifier.getTypeEtk() != null && identifier.getTypeEtk().equals(typeETK)) {
                result.put(48, identifier);
            }
            if (identifier.getTypeEhbox() != null && identifier.getTypeEhbox().equals(typeEhbox)) {
                result.put(49, identifier);
            }
            if (identifier.getTypeRecipe() == null || !identifier.getTypeRecipe().equals(typeRecipe)) continue;
            result.put(50, identifier);
        }
        return result;
    }

    private static void validateMapping(String typeETK, String typeEhbox, String typeRecipe, int actualMapSize) throws TechnicalConnectorException {
        if (typeETK == null || typeEhbox == null || actualMapSize > 3) {
            TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.INVALID_MAPPING;
            LOG.debug("\t## {}", (Object)MessageFormat.format(errorValue.getMessage(), "mapping doesn't contains key for ETKDEPOT or EHBOX."));
            throw new TechnicalConnectorException(errorValue, "mapping doesn't contains key for ETKDEPOT or EHBOX or RECIPE.");
        }
        if (StringUtils.countMatches((String)typeETK, (String)"-") > 1 || StringUtils.countMatches((String)typeEhbox, (String)"-") > 1 || StringUtils.countMatches((String)typeRecipe, (String)"-") > 1) {
            TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.INVALID_MAPPING;
            LOG.debug("\t## {}", (Object)MessageFormat.format(errorValue.getMessage(), "maximum one '-' is allowed."));
            throw new TechnicalConnectorException(errorValue, "maximum one '-' is allowed.");
        }
    }

    public static IdentifierType lookup(String type, String subType, int source) {
        IdentifierType returnValue = null;
        for (IdentifierType identifierType : predefinedTypes.values()) {
            String idenType = identifierType.getType(source);
            String idenSubType = identifierType.getSubType(source);
            if (idenType == null || !idenType.equalsIgnoreCase(type)) continue;
            if (idenSubType != null && subType != null) {
                if (!idenSubType.equalsIgnoreCase(subType)) continue;
                returnValue = identifierType;
                continue;
            }
            if (subType != null || idenSubType != null) continue;
            returnValue = identifierType;
        }
        return returnValue;
    }

    public String formatIdentifierValue(long identifierValue) {
        String value = Long.toString(identifierValue);
        return this.formatIdentifierValue(value);
    }

    public String formatIdentifierValue(String value) {
        if (value.length() > this.length) {
            LOG.debug("Truncating identifiervalue [{}] to length {}", (Object)value, (Object)this.length);
            return value.substring(0, this.length);
        }
        return StringUtils.leftPad((String)value, (int)this.length, (String)"0");
    }

    public String getType(int source) {
        String returnValue = null;
        switch (source) {
            case 49: {
                if (this.typeEhbox == null) break;
                returnValue = this.typeEhbox.split("-")[0];
                break;
            }
            case 48: {
                returnValue = this.typeEtk;
                break;
            }
            case 50: {
                returnValue = this.typeRecipe;
                break;
            }
        }
        return returnValue;
    }

    public String getSubType(int source) {
        String[] ehboxV2;
        String returnValue = null;
        if (source == 49 && this.typeEhbox != null && (ehboxV2 = this.typeEhbox.split("-")).length == 2) {
            returnValue = this.typeEhbox.split("-")[1];
        }
        return returnValue;
    }

    private String getTypeEhbox() {
        return this.typeEhbox;
    }

    private String getTypeEtk() {
        return this.typeEtk;
    }

    private String getTypeRecipe() {
        return this.typeRecipe;
    }

    public String name() {
        return IdentifierType.getKeyByValue(predefinedTypes, this);
    }

    public static IdentifierType valueOf(String key) {
        return predefinedTypes.get(key);
    }

    private static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        Field[] fields;
        CBE = new IdentifierType("CBE", 10);
        CBE_TREATCENTER = new IdentifierType("CBE-TREAT_CENTER", "CBE-TREATMENT_CENTER", "CBE-TREAT_CENTER", 10);
        SSIN = new IdentifierType("SSIN", "INSS", "SSIN", 11);
        NIHII = new IdentifierType("NIHII", 8);
        NIHII11 = new IdentifierType("NIHII11", 11);
        NIHII_PHARMACY = new IdentifierType("NIHII-PHARMACY", "NIHII-PHARMACY", "NIHII-PHARMACY", 8);
        NIHII_LABO = new IdentifierType("NIHII-LABO", 8);
        NIHII_RETIREMENT = new IdentifierType("NIHII-RETIREMENT", 8);
        NIHII_OTD_PHARMACY = new IdentifierType("NIHII-OTD_PHARMACY", 8);
        NIHII_HOSPITAL = new IdentifierType("NIHII-HOSPITAL", 8);
        NIHII_GROUPOFNURSES = new IdentifierType("NIHII-GROUP", 8);
        EHP = new IdentifierType("EHP", 10);
        NIHII_PALLIATIVE_CARE = new IdentifierType("NIHII-PALLIATIVE_CARE", 8);
        NIHII_OFFICE_DENTISTS = new IdentifierType("NIHII-OFFICE_DENTISTS", 8);
        NIHII_MEDICAL_HOUSE = new IdentifierType("NIHII-MEDICAL_HOUSE", 8);
        NIHII_OFFICE_DOCTORS = new IdentifierType("NIHII-OFFICE_DOCTORS", 8);
        NIHII_GROUP_DOCTORS = new IdentifierType("NIHII-GROUP_DOCTORS", 8);
        NIHII_OF_BAND = new IdentifierType("NIHII-OF_BAND", 8);
        NIHII_PSYCH_HOUSE = new IdentifierType("NIHII-PSYCH_HOUSE", 8);
        NIHII_PROT_ACC = new IdentifierType("NIHII-PROT_ACC", 8);
        NIHII_HOME_SERVICES = new IdentifierType("NIHII-HOME_SERVICES", 8);
        NIHII_OF_PHYSIOS = new IdentifierType("NIHII-OF_PHYSIOS", 8);
        SITE = new IdentifierType("SITE", 4);
        SITESMUR = new IdentifierType("SITESMUR", 10);
        SITEPIT = new IdentifierType("SITEPIT", 10);
        CBE_CONSORTIUM = new IdentifierType("CBE-CONSORTIUM", 10);
        NIHII_GUARD_POST = new IdentifierType("NIHII-GUARD_POST", 8);
        EHP_CTRL_ORGANISM = new IdentifierType("EHP-CTRL_ORGANISM", 10);
        NIHII_BELRAI = new IdentifierType("NIHII-BELRAI", 8);
        NIHII_BELRAI_SCREEN = new IdentifierType("NIHII-BELRAI_SCREEN", 8);
        NIHII_GROUP_MIDWIVES = new IdentifierType("NIHII-GROUP_MIDWIVES", 8);
        NIHII_AMBU_SERVICE = new IdentifierType("NIHII-AMBU_SERVICE", 8);
        NIHII_LEGAL_PSY = new IdentifierType("NIHII-LEGAL_PSY", 8);
        NIHII_REEDUCATION = new IdentifierType("NIHII-REEDUCATION", 8);
        NIHII_SORTING_CENTER = new IdentifierType("NIHII-SORTING_CENTER", 8);
        HUB = EHP;
        LOG = LoggerFactory.getLogger(IdentifierType.class);
        predefinedTypes = new HashMap<String, IdentifierType>();
        for (Field f : fields = IdentifierType.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !IdentifierType.class.isAssignableFrom(f.getType())) continue;
            try {
                predefinedTypes.put(f.getName(), (IdentifierType)f.get(CBE));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

