/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.schematron.utils;

import java.io.UnsupportedEncodingException;

public final class XmlUtils {
    private XmlUtils() {
        throw new UnsupportedOperationException();
    }

    public static String flatten(String xml) {
        String result = xml.replaceAll("[\t\n\r]", "");
        while (result.contains(" <")) {
            result = result.replace(" <", "<");
        }
        return result;
    }

    public static String removeProcessInstruction(String xml) {
        int firstLineEnd = xml.indexOf("\n");
        if (xml.startsWith("<?xml ") || xml.startsWith("<?xml ", 1) || xml.startsWith("<?xml ", 2) || xml.startsWith("<?xml ", 3)) {
            return xml.substring(firstLineEnd + 1);
        }
        return xml;
    }

    public static String flatten(byte[] xml) {
        try {
            return XmlUtils.flatten(new String(xml, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF-8 not supported", e);
        }
    }
}

