/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.exception;

import static org.junit.Assert.assertEquals;

import java.text.MessageFormat;

import org.junit.Test;


/**
 * Test class for {@link TechnicalConnectorException}
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class TechnicalConnectorExceptionTest {

    /**
     * Test method for
     * {@link be.ehealth.technicalconnector.exception.TechnicalConnectorException#TechnicalConnectorException(be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues, java.lang.Object[])}
     * .
     */
    @Test
    public void testTechnicalConnectorExceptionWithOneParams() {
        TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_GENERAL;
        TechnicalConnectorException except = new TechnicalConnectorException(errorValue, "test");
        assertEquals(except.getErrorCode(), TechnicalConnectorExceptionValues.ERROR_GENERAL.getErrorCode());
        assertEquals(except.getMessage(), "General Error: test");
    }

    /**
     * Test method for
     * {@link be.ehealth.technicalconnector.exception.TechnicalConnectorException#TechnicalConnectorException(be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues, java.lang.Object[])}
     * .
     */
    @Test
    public void testTechnicalConnectorExceptionWithoutParams() {
        TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_COMPRESSION;
        TechnicalConnectorException except = new TechnicalConnectorException(errorValue);
        assertEquals(except.getErrorCode(), TechnicalConnectorExceptionValues.ERROR_COMPRESSION.getErrorCode());
        assertEquals(except.getMessage(), TechnicalConnectorExceptionValues.ERROR_COMPRESSION.getMessage());
    }

    /**
     * Test method for
     * {@link be.ehealth.technicalconnector.exception.TechnicalConnectorException#TechnicalConnectorException(be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues, java.lang.Object[])}
     * .
     */
    @Test
    public void testTechnicalConnectorExceptionWithMoreThanOneParams() {
        TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON;
        TechnicalConnectorException except = new TechnicalConnectorException(errorValue, "test1", "test2");
        assertEquals(except.getErrorCode(), TechnicalConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getErrorCode());
        assertEquals(except.getMessage(), MessageFormat.format(TechnicalConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON.getMessage(), "test1", "test2"));
    }

}
