package be.ehealth.businessconnector.test.hubv3.session.orgpharmacy;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.businessconnector.hubv3.session.HubService;
import be.ehealth.businessconnector.hubv3.session.HubSessionServiceFactory;
import be.ehealth.businessconnector.test.hubv3.helpers.OrgPharmacyHubTestHelper;
import be.ehealth.businessconnector.test.hubv3.session.InitHubRule;
import be.ehealth.businessconnector.test.hubv3.session.InitVitalinkHubRule;
import be.ehealth.businessconnector.test.testcommons.BusinessSessionRule;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.hubservices.core.v3.GetTransactionListResponse;
import be.fgov.ehealth.hubservices.core.v3.LocalSearchType;
import be.fgov.ehealth.hubservices.core.v3.PatientIdType;
import be.fgov.ehealth.hubservices.core.v3.TherapeuticLinkType;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;
import org.junit.runners.MethodSorters;

import java.util.List;

import static be.ehealth.businessconnector.hubv3.service.ServiceFactory.PROP_ENDPOINT_INTRAHUB;
import static be.ehealth.businessconnector.hubv3.service.ServiceFactory.PROP_HUBAPPID;
import static be.ehealth.businessconnector.hubv3.service.ServiceFactory.PROP_HUBID;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class WalkThroughOrgPharmacyVitalinkIntegrationTest {

    @ClassRule
    public static TestRule sessionPrerequisite = BusinessSessionRule.withActiveSession("/be.ehealth.businessconnector.intrahubv3.test.orgpharmacy.properties");

    @ClassRule
    public static InitHubRule hubPrerequesite = new InitVitalinkHubRule();

    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    
    private final HubService hubService = hubPrerequesite.getHubService();
    

    private OrgPharmacyHubTestHelper helper = new OrgPharmacyHubTestHelper(new Patient.Builder()
            .withInss("74123045193").build());

    @Test
    public void _010_putPatientConsent() throws Exception {
        rswServiceConfig();
        HubSessionServiceFactory.getHubService().putPatientConsent(helper.createConsentType());
    }

    @Test
    public void _020_putTherapeuticLink() throws Exception {
        rswServiceConfig();
        TherapeuticLinkType therapeuticLink = helper.createTherapeuticLinkType();
        HubSessionServiceFactory.getHubService().putTherapeuticLink(therapeuticLink);
    }
    
    @Test
    public void _030_getTransactionList() throws Exception {
        PatientIdType patientId = helper.createPatientIdType();
        GetTransactionListResponse transactionListResponse = hubService.getTransactionList(patientId, LocalSearchType.GLOBAL, helper.createMedicationSchemeSearchTransaction());

        List<ErrorType> errors = transactionListResponse.getAcknowledge().getErrors();
        assertEquals("There should be no error", "VALID", errors.get(0).getCds().get(0).getValue());
        assertTrue("Transaction list should not be empty", transactionListResponse.getKmehrheader().getFolder().getTransactions().size() > 0);
    }

    private void rswServiceConfig() throws TechnicalConnectorException {
        ConfigFactory.getConfigValidator().getConfig().setProperty(PROP_ENDPOINT_INTRAHUB, "https://acchub.reseausantewallon.be/HubServices/IntraHub/V3/IntraHub.asmx");
        ConfigFactory.getConfigValidator().getConfig().setProperty(PROP_HUBID, "1990000035");
        ConfigFactory.getConfigValidator().getConfig().setProperty(PROP_HUBAPPID, "RSW");
        ConfigFactory.getConfigValidator().getConfig().setProperty("default.rsa.signature.method.algorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        ConfigFactory.getConfigValidator().getConfig().setProperty("default.rsa.digest.method.algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
    }
}
