/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.ehbox.v3.service;

import java.io.InputStream;
import java.net.URL;

import javax.xml.XMLConstants;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

import be.ehealth.businessconnector.ehbox.v3.service.ServiceFactory;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;


/**
 * This testclass the ServiceFactory.
 * 
 * @author EHP
 * 
 */
public class ServiceFactoryTest {

    /**
     * Test if all the xsd needed by the ServiceFactory are present on the classpath.
     * 
     * @throws Exception
     */
    @Test
    public void testXSDPresentConsultation() throws Exception {
        validateSchemas(ServiceFactory.EHBOX_CONS_PROT);
    }

    private void validateSchemas(String... schemas) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

        if (schemas.length == 1) {
            URL schemaurl = SchemaValidatorHandler.class.getResource(schemas[0]);
            schemaFactory.newSchema(schemaurl);
        } else {
            Source[] sources = new Source[]{};
            for (String xsd : schemas) {
                InputStream in = ServiceFactoryTest.class.getResourceAsStream(xsd);
                Assert.assertNotNull("Could not find file:" + xsd, in);
                Source source = new StreamSource(in);
                sources = (Source[]) ArrayUtils.add(sources, source);
            }
            schemaFactory.newSchema(sources);
        }
    }

    /**
     * Test if all the xsd needed by the ServiceFactory are present on the classpath.
     * 
     * @throws Exception
     */
    @Test
    public void testXSDPresentPublication() throws Exception {
        validateSchemas(ServiceFactory.EHBOX_PUB_PROT);


    }

}
