/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.consumer;

import be.fedict.commons.eid.consumer.Address;
import be.fedict.commons.eid.consumer.Identity;
import be.fedict.commons.eid.consumer.tlv.TlvParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.DigestInfo;

public class BeIDIntegrity {
    private static final Log LOG = LogFactory.getLog(BeIDIntegrity.class);
    private final CertificateFactory certificateFactory;

    public BeIDIntegrity() {
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException cex) {
            throw new RuntimeException("X.509 algo", cex);
        }
    }

    public X509Certificate loadCertificate(byte[] encodedCertificate) {
        X509Certificate certificate;
        try {
            certificate = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(encodedCertificate));
        }
        catch (CertificateException cex) {
            throw new RuntimeException("X509 decoding error: " + cex.getMessage(), cex);
        }
        return certificate;
    }

    public Identity getVerifiedIdentity(byte[] identityFile, byte[] identitySignatureFile, X509Certificate rrnCertificate) {
        Identity identity = this.getVerifiedIdentity(identityFile, identitySignatureFile, null, rrnCertificate);
        return identity;
    }

    public Identity getVerifiedIdentity(byte[] identityFile, byte[] identitySignatureFile, byte[] photo, X509Certificate rrnCertificate) {
        byte[] actualPhotoDigest;
        byte[] expectedPhotoDigest;
        boolean result;
        PublicKey publicKey = rrnCertificate.getPublicKey();
        try {
            result = this.verifySignature(rrnCertificate.getSigAlgName(), identitySignatureFile, publicKey, (byte[][])new byte[][]{identityFile});
        }
        catch (Exception ex) {
            throw new SecurityException("identity signature verification error: " + ex.getMessage(), ex);
        }
        if (!result) {
            throw new SecurityException("signature integrity error");
        }
        Identity identity = TlvParser.parse(identityFile, Identity.class);
        if (null != photo && !Arrays.equals(expectedPhotoDigest = identity.getPhotoDigest(), actualPhotoDigest = this.digest(this.getDigestAlgo(expectedPhotoDigest.length), photo))) {
            throw new SecurityException("photo digest mismatch");
        }
        return identity;
    }

    public Address getVerifiedAddress(byte[] addressFile, byte[] identitySignatureFile, byte[] addressSignatureFile, X509Certificate rrnCertificate) {
        boolean result;
        byte[] trimmedAddressFile = this.trimRight(addressFile);
        PublicKey publicKey = rrnCertificate.getPublicKey();
        try {
            result = this.verifySignature(rrnCertificate.getSigAlgName(), addressSignatureFile, publicKey, (byte[][])new byte[][]{trimmedAddressFile, identitySignatureFile});
        }
        catch (Exception ex) {
            throw new SecurityException("address signature verification error: " + ex.getMessage(), ex);
        }
        if (!result) {
            throw new SecurityException("address integrity error");
        }
        Address address = TlvParser.parse(addressFile, Address.class);
        return address;
    }

    public boolean verifySignature(byte[] signatureData, PublicKey publicKey, byte[] ... data) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        return this.verifySignature("SHA1withRSA", signatureData, publicKey, data);
    }

    public boolean verifySignature(String signatureAlgo, byte[] signatureData, PublicKey publicKey, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(signatureAlgo);
        signature.initVerify(publicKey);
        for (byte[] dataItem : data) {
            signature.update(dataItem);
        }
        boolean result = signature.verify(signatureData);
        return result;
    }

    private byte[] digest(String algoName, byte[] data) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algoName);
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new RuntimeException(algoName);
        }
        byte[] digestValue = messageDigest.digest(data);
        return digestValue;
    }

    private byte[] trimRight(byte[] addressFile) {
        int idx;
        for (idx = 0; idx < addressFile.length && 0 != addressFile[idx]; ++idx) {
        }
        byte[] result = new byte[idx];
        System.arraycopy(addressFile, 0, result, 0, idx);
        return result;
    }

    public boolean verifyAuthnSignature(byte[] toBeSigned, byte[] signatureValue, X509Certificate authnCertificate) {
        boolean result;
        PublicKey publicKey = authnCertificate.getPublicKey();
        try {
            result = this.verifySignature(signatureValue, publicKey, new byte[][]{toBeSigned});
        }
        catch (InvalidKeyException ikex) {
            LOG.warn((Object)("invalid key: " + ikex.getMessage()), (Throwable)ikex);
            return false;
        }
        catch (NoSuchAlgorithmException nsaex) {
            LOG.warn((Object)("no such algo: " + nsaex.getMessage()), (Throwable)nsaex);
            return false;
        }
        catch (SignatureException sigex) {
            LOG.warn((Object)("signature error: " + sigex.getMessage()), (Throwable)sigex);
            return false;
        }
        return result;
    }

    public boolean verifyNonRepSignature(byte[] expectedDigestValue, byte[] signatureValue, X509Certificate certificate) {
        try {
            return this.__verifyNonRepSignature(expectedDigestValue, signatureValue, certificate);
        }
        catch (InvalidKeyException ikex) {
            LOG.warn((Object)("invalid key: " + ikex.getMessage()), (Throwable)ikex);
            return false;
        }
        catch (NoSuchAlgorithmException nsaex) {
            LOG.warn((Object)("no such algo: " + nsaex.getMessage()), (Throwable)nsaex);
            return false;
        }
        catch (NoSuchPaddingException nspex) {
            LOG.warn((Object)("no such padding: " + nspex.getMessage()), (Throwable)nspex);
            return false;
        }
        catch (BadPaddingException bpex) {
            LOG.warn((Object)("bad padding: " + bpex.getMessage()), (Throwable)bpex);
            return false;
        }
        catch (IOException ioex) {
            LOG.warn((Object)("IO error: " + ioex.getMessage()), (Throwable)ioex);
            return false;
        }
        catch (IllegalBlockSizeException ibex) {
            LOG.warn((Object)("illegal block size: " + ibex.getMessage()), (Throwable)ibex);
            return false;
        }
    }

    private boolean __verifyNonRepSignature(byte[] expectedDigestValue, byte[] signatureValue, X509Certificate certificate) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        PublicKey publicKey = certificate.getPublicKey();
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        byte[] actualSignatureDigestInfoValue = cipher.doFinal(signatureValue);
        ASN1InputStream asnInputStream = new ASN1InputStream(actualSignatureDigestInfoValue);
        DigestInfo actualSignatureDigestInfo = new DigestInfo((ASN1Sequence)asnInputStream.readObject());
        asnInputStream.close();
        byte[] actualDigestValue = actualSignatureDigestInfo.getDigest();
        return Arrays.equals(expectedDigestValue, actualDigestValue);
    }

    private String getDigestAlgo(int hashSize) throws SecurityException {
        switch (hashSize) {
            case 20: {
                return "SHA-1";
            }
            case 28: {
                return "SHA-224";
            }
            case 32: {
                return "SHA-256";
            }
            case 48: {
                return "SHA-384";
            }
            case 64: {
                return "SHA-512";
            }
        }
        throw new SecurityException("Failed to find guess algorithm for hash size of " + hashSize + " bytes");
    }
}

