/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.List;
import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.KeyAndValue;

public class HashMapMatcher
extends NotMatcher<List<KeyAndValue>> {
    private final CaseInsensitiveRegexHashMap hashMap;

    public HashMapMatcher(CaseInsensitiveRegexHashMap hashMap) {
        this.hashMap = hashMap;
    }

    @Override
    public boolean matches(List<KeyAndValue> values) {
        boolean result = false;
        if (this.hashMap == null) {
            result = true;
        } else if (KeyAndValue.toHashMap(values).containsAll(this.hashMap)) {
            result = true;
        } else {
            this.logger.trace("Map [{}] is not a subset of [{}]", (Object)this.hashMap, (Object)KeyAndValue.toHashMap(values));
        }
        return this.reverseResultIfNot(result);
    }
}

