/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.impl.strategy;

import be.ehealth.technicalconnector.exception.NoNextEndpointException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.ehealth.technicalconnector.ws.impl.AbstractWsSender;
import be.ehealth.technicalconnector.ws.impl.strategy.InvokeStrategy;
import be.ehealth.technicalconnector.ws.impl.strategy.InvokeStrategyContext;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.EndpointDistributor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryStrategy
extends AbstractWsSender
implements InvokeStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RetryStrategy.class);
    private static EndpointDistributor distributor = EndpointDistributor.getInstance();

    @Override
    public boolean invoke(InvokeStrategyContext invokeStrategyContext) {
        RetryNotifier.reset();
        GenericRequest genericRequest = invokeStrategyContext.getRequest();
        RetryContext ctx = new RetryContext(this.getCurrentEndpoint(genericRequest));
        int alternatives = distributor.getAmountOfAlternatives(ctx.endpoint);
        for (int i = 0; i < alternatives; ++i) {
            String activeEndpoint = distributor.getActiveEndpoint(ctx.endpoint);
            if (!ctx.invokedEndpoints.contains(activeEndpoint)) {
                ctx.invokedEndpoints.add(activeEndpoint);
                genericRequest.setEndpoint(activeEndpoint);
                try {
                    invokeStrategyContext.setResponse(super.call(genericRequest));
                    if (!RetryNotifier.activated()) {
                        invokeStrategyContext.setException(null);
                        return true;
                    }
                }
                catch (TechnicalConnectorException e) {
                    invokeStrategyContext.setException(e);
                }
                if (!RetryNotifier.activated()) continue;
                this.retryNext(ctx, activeEndpoint, RetryNotifier.getException());
                this.activatePolling(ctx);
                RetryNotifier.reset();
                continue;
            }
            LOG.debug("Endpoint [{}] already invoked, skipping it.", (Object)activeEndpoint);
        }
        LOG.debug("All alternatives are used. Returning last exception");
        if (RetryNotifier.activated()) {
            RetryNotifier.reset();
        }
        if (ctx.lastException instanceof MessageLevelRetryException) {
            MessageLevelRetryException exception = (MessageLevelRetryException)ctx.lastException;
            invokeStrategyContext.setResponse(exception.getResponse());
        } else {
            invokeStrategyContext.setException(new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, ExceptionUtils.getRootCause((Throwable)ctx.lastException), ExceptionUtils.getRootCauseMessage((Throwable)ctx.lastException)));
        }
        return true;
    }

    private void activatePolling(RetryContext ctx) {
        if (ctx.alternativeActivated) {
            LOG.debug("Activating status page polling!");
            distributor.activatePolling();
        }
    }

    private void retryNext(RetryContext ctx, String activeEndpoint, Exception e) {
        LOG.error("Unable to invoke endpoint [{}], activating next one. Reason: {}", (Object)activeEndpoint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        try {
            distributor.activateNextEndPoint(activeEndpoint);
            ctx.alternativeActivated = true;
        }
        catch (NoNextEndpointException nonext) {
            LOG.error("Unable to activate alternative", (Throwable)nonext);
        }
        ctx.lastException = e;
    }

    private static class RetryContext {
        String endpoint;
        Exception lastException;
        boolean alternativeActivated;
        List<String> invokedEndpoints = new ArrayList<String>();

        RetryContext(String endpoint) {
            this.endpoint = endpoint;
        }
    }

    public static class RetryNotifier {
        private static final ThreadLocal<Exception> HOLDER = new ThreadLocal();

        public static void activate(Exception e) {
            HOLDER.set(e);
        }

        public static void activate(SOAPMessage message) {
            HOLDER.set(new MessageLevelRetryException(message));
        }

        public static void reset() {
            HOLDER.remove();
        }

        public static boolean activated() {
            return HOLDER.get() != null;
        }

        public static Exception getException() {
            return HOLDER.get();
        }
    }

    private static class MessageLevelRetryException
    extends Exception {
        private SOAPMessage message;

        public MessageLevelRetryException(SOAPMessage message) {
            this.message = message;
        }

        public GenericResponse getResponse() {
            return new GenericResponse(this.message);
        }
    }
}

