/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.utils;

import be.fgov.ehealth.etee.crypto.utils.DataPipe;
import be.fgov.ehealth.etee.crypto.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class DataPipeInFile
implements DataPipe {
    private InputStream from;
    private OutputStream to;
    private File file;

    public DataPipeInFile(File file) throws FileNotFoundException {
        this.file = file;
        this.to = new FileOutputStream(this.file);
    }

    @Override
    public InputStream getFrom() {
        if (this.from == null) {
            try {
                this.from = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Temporary file cannot be read: " + this.file, e);
            }
        }
        return this.from;
    }

    @Override
    public OutputStream getTo() {
        return this.to;
    }

    @Override
    public void close() {
        Streams.closeQuietly(this.from);
        Streams.closeQuietly(this.to);
    }
}

