/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;

public final class EncryptionCredential {
    private String keyId;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final X509Certificate certificate;
    private final SecretKey symKek;

    public String getKeyId() {
        return this.keyId;
    }

    public SecretKey getSymKek() {
        return this.symKek;
    }

    private EncryptionCredential(String keyId, PrivateKey privateKey, PublicKey publicKey, X509Certificate certificate, SecretKey symKey) {
        this.keyId = keyId;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.certificate = certificate;
        this.symKek = symKey;
    }

    public static EncryptionCredential create(PrivateKey privateKey, String keyId) {
        EncryptionCredential.validateInput(privateKey, keyId);
        return new EncryptionCredential(keyId, privateKey, null, null, null);
    }

    public static EncryptionCredential create(PublicKey publicKey, String keyId) {
        EncryptionCredential.validateInput(publicKey, keyId);
        return new EncryptionCredential(keyId, null, publicKey, null, null);
    }

    public static EncryptionCredential create(SecretKey symKey, String keyId) {
        EncryptionCredential.validateInput(symKey, keyId);
        return new EncryptionCredential(keyId, null, null, null, symKey);
    }

    public static EncryptionCredential create(X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("The given certificate cannot be null");
        }
        return new EncryptionCredential(certificate.getSerialNumber().toString(), null, null, certificate, null);
    }

    private static void validateInput(Key key, String keyId) {
        if (key == null) {
            throw new IllegalArgumentException("The given key cannot be null");
        }
        if (keyId == null || keyId.isEmpty()) {
            throw new IllegalArgumentException("The given keyId cannot be null or empty");
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Deprecated
    public String getEncryptionTokenSerialNumber() {
        return this.keyId;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }
}

