/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.ocsp;

import be.fgov.ehealth.etee.crypto.ocsp.OCSPException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCSPRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OCSPRequestBuilder.class);

    OCSPRequestBuilder() {
    }

    public OCSPReq generateOCSPRequest(X509Certificate cert) throws OCSPException {
        ASN1OctetString issuerKeyID = this.getIssuerKeyID(cert);
        X500Principal issuerName = cert.getIssuerX500Principal();
        BigInteger serialNumber = cert.getSerialNumber();
        OCSPReqBuilder ocspRequestBuilder = new OCSPReqBuilder();
        CertificateID id = this.createCertificateID(CertificateID.HASH_SHA1, issuerName, issuerKeyID, serialNumber);
        ocspRequestBuilder.addRequest(id);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        LOGGER.debug("Nonce in req : " + nonce);
        Extension nonceExt = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(nonce.toByteArray()));
        ocspRequestBuilder.setRequestExtensions(new Extensions(nonceExt));
        try {
            return ocspRequestBuilder.build();
        }
        catch (org.bouncycastle.cert.ocsp.OCSPException e) {
            throw new OCSPException("Failed to generate OCSP request for certificate with serial ID : " + serialNumber, e);
        }
    }

    private CertificateID createCertificateID(AlgorithmIdentifier hashAlgorithm, X500Principal issuerDN, ASN1OctetString issuerKeyID, BigInteger number) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm().getId());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get message digest.", e);
        }
        digest.update(issuerDN.getEncoded());
        DEROctetString issuerNameHash1 = new DEROctetString(digest.digest());
        ASN1Integer serialNumber = new ASN1Integer(number);
        CertID certID = new CertID(hashAlgorithm, (ASN1OctetString)issuerNameHash1, issuerKeyID, serialNumber);
        return new CertificateID(certID);
    }

    private ASN1OctetString getIssuerKeyID(X509Certificate x509cert) throws OCSPException {
        byte[] authorityKeyIDbytes = x509cert.getExtensionValue(Extension.authorityKeyIdentifier.getId());
        if (authorityKeyIDbytes != null) {
            AuthorityKeyIdentifier authorityKeyID;
            try {
                authorityKeyID = AuthorityKeyIdentifier.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])authorityKeyIDbytes));
            }
            catch (IOException e) {
                throw new OCSPException("Failed to retrieve the AuthorityKeyIdentifier Extension (containing the hash of the issuer's public key) from the certificate.", e);
            }
            DEROctetString authorityKeyIdDER = new DEROctetString(authorityKeyID.getKeyIdentifier());
            LOGGER.debug("Issuer's key ID : " + authorityKeyIdDER.toString());
            return authorityKeyIdDER;
        }
        throw new OCSPException("No AuthorityKeyIdentifier Extension could be found in the certificate.");
    }
}

