package be.fgov.ehealth.technicalconnector.services.validation;

import static be.ehealth.technicalconnector.utils.ConnectorIOUtils.getResourceAsString;
import static be.fgov.ehealth.technicalconnector.services.ServiceFactory.getProjectMessageValidator;
import static be.fgov.ehealth.technicalconnector.services.validation.impl.ProjectMessageValidatorImpl.PROP_SCHEMATRONS_XML;
import static org.apache.commons.lang.StringUtils.substringAfterLast;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.fgov.ehealth.technicalconnector.services.schematron.SchematronValidationResult;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;

public class ProjectMessageValidatorTest {

    @Before
    public void before() {
        LoggingUtils.bootstrap();
    }

    private static SchematronValidationResult validate(String locationBase, boolean isValid) throws Exception {

        ConfigFactory.getConfigValidator()
                     .setProperty(PROP_SCHEMATRONS_XML, locationBase + "-schematrons");
        ProjectMessageValidator validator = getProjectMessageValidator(substringAfterLast(locationBase, "/"));
        String expected = getResourceAsString(locationBase + ".svrl");
        SchematronValidationResult result = validator.validate(locationBase + ".input");
        XmlAsserter.assertSimilar(expected, result.getSVRLAsString());
        Assert.assertNotNull(result.getSVRL());
        if (isValid != result.isValid()) {
            Assert.fail("Unexpected result");
        }
        return result;
    }

    @Test
    public void validateDummy() throws Exception {
        validate("/schematron/dummy", false);
    }

}