/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.etee.impl;

import java.util.UUID;

import org.bouncycastle.util.encoders.Base64;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.technicalconnector.service.etee.Crypto.SigningPolicySelector;
import be.ehealth.technicalconnector.service.etee.CryptoFactory;
import be.ehealth.technicalconnector.service.etee.domain.EncryptionToken;
import be.ehealth.technicalconnector.service.etee.domain.UnsealedData;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManager.EncryptionTokenType;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.ConnectorCryptoUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.AssertTools;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;


/**
 * Unit tests for the {@link CryptoImpl}
 * 
 * @author EHP
 * 
 */
public class CryptoImplIntegrationTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession()
                                                .build();

    public KeyResult getKeyFromKGSSStub() throws Exception {
        return new KeyResult(ConnectorCryptoUtils.generateKey(), new String(Base64.encode(UUID.randomUUID()
                                                                                              .toString()
                                                                                              .getBytes())));
    }

    @Test
    public void unknownDestination() throws Exception {
        KeyResult symmKey = getKeyFromKGSSStub();
        String msg = "boe";
        byte[] protectedMessage = CryptoFactory.getCryptoFromSession()
                                               .seal(SigningPolicySelector.WITH_NON_REPUDIATION, symmKey, msg.getBytes());
        System.out.println("-----");
        System.out.println(new String(protectedMessage));
        System.out.println("-----");
        System.out.println(Base64.toBase64String(protectedMessage));
        System.out.println("-----");
        UnsealedData data = CryptoFactory.getCryptoFromSession()
                                         .unseal(SigningPolicySelector.WITH_NON_REPUDIATION, symmKey, protectedMessage);

        Assert.assertEquals(new String(data.getContentAsByte()), msg);
        AssertTools.assertEquals(Session.getInstance()
                                        .getSession()
                                        .getEncryptionCredential()
                                        .getCertificate(), data.getAuthenticationCert());
        Assert.assertNull(data.getSignatureCert());
        Assert.assertNotNull(data.getSigningTime());
    }

    @Test
    public void knownDestination() throws Exception {
        AssumeTools.isInternetConnectionEnabled();
        EncryptionToken etk = KeyDepotManagerFactory.getKeyDepotManager()
                                                    .getETK(EncryptionTokenType.ENCRYPTION);
        String msg = "boe";
        byte[] protectedMessage = CryptoFactory.getCryptoFromSession()
                                               .seal(SigningPolicySelector.WITH_NON_REPUDIATION, etk, msg.getBytes());

        UnsealedData data = CryptoFactory.getCryptoFromSession()
                                         .unseal(SigningPolicySelector.WITH_NON_REPUDIATION, protectedMessage);

        Assert.assertEquals(new String(data.getContentAsByte()), msg);
        AssertTools.assertEquals(Session.getInstance()
                                        .getSession()
                                        .getEncryptionCredential()
                                        .getCertificate(), data.getAuthenticationCert());
        Assert.assertNull(data.getSignatureCert());
        Assert.assertNotNull(data.getSigningTime());
    }

}
