/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.genins.service;


import org.junit.BeforeClass;

import be.ehealth.businessconnector.genins.test.AbstractGenInsIntegrationTest;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.genericinsurability.protocol.v1.GetInsurabilityAsXmlOrFlatRequestType;
import be.fgov.ehealth.genericinsurability.protocol.v1.GetInsurabilityResponse;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * 
 * GenInsServiceIntegrationTest class.
 * 
 * @author EHP
 */
public class GenInsServiceIntegrationTest extends AbstractGenInsIntegrationTest {

    private static SAMLToken samlToken;

    @BeforeClass
    public static void init() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.genins.test.properties", true);     
        samlToken = Session.getInstance().getSession().getSAMLToken();
        Session.getInstance().unloadSession();
    }

    @Override
    protected GetInsurabilityResponse invoke(GetInsurabilityAsXmlOrFlatRequestType request) throws Exception {
        return ServiceFactory.getGeninsService().getInsurability(samlToken, request);
    }
    

}
