/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.testsupport.junit.rules;

import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSLVerificationDisabled
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(SSLVerificationDisabled.class);
    private SSLSocketFactory oldSSLSocketFactory;

    SSLVerificationDisabled() {
    }

    protected void before() throws Throwable {
        TrustManager[] trustAllCerts = new TrustManager[]{new ConnectorTrustManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        this.oldSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    protected void after() {
        HttpsURLConnection.setDefaultSSLSocketFactory(this.oldSSLSocketFactory);
    }

    private static class ConnectorTrustManager
    implements X509TrustManager {
        private ConnectorTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            LOG.warn("SSL verifcation disabled! DO NOT USE THIS IN PRODUCTION.");
            LOG.debug("getAcceptedIssuers() : empty list");
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
            LOG.debug("checkClientTrusted() : authType=" + authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
            LOG.debug("checkServerTrusted() : authType=" + authType);
            for (int i = 0; i < certs.length; ++i) {
                LOG.debug("Server Certificate to be checked " + i + " : " + certs[i].getSubjectX500Principal().getName("RFC1779") + "with issuer:" + certs[i].getIssuerX500Principal().getName("RFC1779"));
            }
        }
    }
}

