﻿using System;
using NUnit.Framework;
using be.ehealth.businessconnector.dicsv5.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.config;
using be.ehealth.businessconnector.testcommons.utils;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.dics.protocol.v5;
using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.errors.soa.v1;
using be.fgov.ehealth.technicalconnector.tests.utils;
using org.apache.commons.lang;
using org.joda.time;
using org.joda.time.format;
using javax.xml.soap;
using java.util;
using java.lang;

namespace be.ehealth.businessconnector.dicsv5.session
{
	[TestFixture]
	public class DicsSessionServiceIntegrationTest
	{
		[SetUpAttribute]
	    public static void setupsession() {
	    	SessionInitializer.init(".\\be.ehealth.businessconnector.dicsv5.test.properties",true, SupportedLanguages.NET.getAbbreviation());
	    	ConfigFactory.getConfigValidator().setProperty("endpoint.dicsv5", "https://services-acpt.ehealth.fgov.be/Dics/v5");
	    }
		
		[Test]
	    public void findAmpTest() {
			FindAmpRequest request = transformRequest<FindAmpRequest>(".\\examples\\request\\findAmpRequest.xml", typeof(FindAmpRequest));
	        FindAmpResponse response = DicsSessionServiceFactory.getDicsSession().findAmp(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findAmpResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findAmpWithErrorTest() {
	    	FindAmpRequest request = transformRequest<FindAmpRequest>(".\\examples\\request\\findAmpRequest-error.xml", typeof(FindAmpRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findAmp(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1003", "No AMP found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void findCompanyTest() {
	    	FindCompanyRequest request = transformRequest<FindCompanyRequest>(".\\examples\\request\\findCompanyRequest.xml", typeof(FindCompanyRequest));
	        FindCompanyResponse response = DicsSessionServiceFactory.getDicsSession().findCompany(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findCompanyResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findCompanyErrorTest() {
	    	FindCompanyRequest request = transformRequest<FindCompanyRequest>(".\\examples\\request\\findCompanyRequest-error.xml", typeof(FindCompanyRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findCompany(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1004", "No company found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void findVmpTest() {
	    	FindVmpRequest request = transformRequest<FindVmpRequest>(".\\examples\\request\\findVmpRequest.xml", typeof(FindVmpRequest));
	        FindVmpResponse response = DicsSessionServiceFactory.getDicsSession().findVmp(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findVmpResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findVmpErrorTest() {
	    	FindVmpRequest request = transformRequest<FindVmpRequest>(".\\examples\\request\\findVmpRequest-error.xml", typeof(FindVmpRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findVmp(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1005", "No VMP found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void findLegislationTextTest() {
	    	FindLegislationTextRequest request = transformRequest<FindLegislationTextRequest>(".\\examples\\request\\findLegislationTextRequest.xml", typeof(FindLegislationTextRequest));
	        FindLegislationTextResponse response = DicsSessionServiceFactory.getDicsSession().findLegislationText(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findLegislationTextResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findLegislationTextErrorTest() {
	    	FindLegislationTextRequest request = transformRequest<FindLegislationTextRequest>(".\\examples\\request\\findLegislationTextRequest-error.xml", typeof(FindLegislationTextRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findLegislationText(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1007", "No legislation text found for given criteria");
	        }
	    }
	
	    [Test]
	    public void findReimbursementTest() {
	    	FindReimbursementRequest request = transformRequest<FindReimbursementRequest>(".\\examples\\request\\findReimbursementRequest.xml", typeof(FindReimbursementRequest));
	        FindReimbursementResponse response = DicsSessionServiceFactory.getDicsSession().findReimbursement(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findReimbursementResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findReimbursementErrorTest() {
	    	FindReimbursementRequest request = transformRequest<FindReimbursementRequest>(".\\examples\\request\\findReimbursementRequest-error.xml", typeof(FindReimbursementRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findReimbursement(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1008", "No reimbursements found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void findReferencesTest() {
	    	FindReferencesRequest request = transformRequest<FindReferencesRequest>(".\\examples\\request\\findReferencesRequest.xml", typeof(FindReferencesRequest));
	        FindReferencesResponse response = DicsSessionServiceFactory.getDicsSession().findReferences(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findReferencesResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findReferencesErrorTest() {
	    	FindReferencesRequest request = transformRequest<FindReferencesRequest>(".\\examples\\request\\findReferencesRequest-error.xml", typeof(FindReferencesRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findReferences(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "0804", "Invalid reference entity 'INVALID_REFERENCE_ENTITY'");
	        }
	    }
	
	    [Test]
	    public void findVmpGroupTest() {
	    	FindVmpGroupRequest request = transformRequest<FindVmpGroupRequest>(".\\examples\\request\\findVmpGroupRequest.xml", typeof(FindVmpGroupRequest));
	        FindVmpGroupResponse response = DicsSessionServiceFactory.getDicsSession().findVmpGroup(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findVmpGroupResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findVmpGroupErrorTest() {
	    	FindVmpGroupRequest request = transformRequest<FindVmpGroupRequest>(".\\examples\\request\\findVmpGroupRequest-error.xml", typeof(FindVmpGroupRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findVmpGroup(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1006", "No VMP group found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void findVtmTest() {
	    	FindVtmRequest request = transformRequest<FindVtmRequest>(".\\examples\\request\\findVtmRequest.xml", typeof(FindVtmRequest));
	        FindVtmResponse response = DicsSessionServiceFactory.getDicsSession().findVtm(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findVtmResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findVtmErrorTest() {
	    	FindVtmRequest request = transformRequest<FindVtmRequest>(".\\examples\\request\\findVtmRequest-error.xml", typeof(FindVtmRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findVtm(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1011", "No VTM found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void findCommentedClassificationTest() {
	    	FindCommentedClassificationRequest request = transformRequest<FindCommentedClassificationRequest>(".\\examples\\request\\findCommentedClassificationRequest.xml", typeof(FindCommentedClassificationRequest));
	        FindCommentedClassificationResponse response = DicsSessionServiceFactory.getDicsSession().findCommentedClassification(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findCommentedClassificationResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findCommentedClassificationErrorTest() {
	    	FindCommentedClassificationRequest request = transformRequest<FindCommentedClassificationRequest>(".\\examples\\request\\findCommentedClassificationRequest-error.xml", typeof(FindCommentedClassificationRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findCommentedClassification(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1012", "No Com Cls found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void findIngredientTest() {
	    	FindCompoundingIngredientRequest request = transformRequest<FindCompoundingIngredientRequest>(".\\examples\\request\\findIngredientRequest.xml", typeof(FindCompoundingIngredientRequest));
	        FindCompoundingIngredientResponse response = DicsSessionServiceFactory.getDicsSession().findIngredient(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findIngredientResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findIngredientErrorTest() {
	    	FindCompoundingIngredientRequest request = transformRequest<FindCompoundingIngredientRequest>(".\\examples\\request\\findIngredientRequest-error.xml", typeof(FindCompoundingIngredientRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findIngredient(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1013", "No ingredient found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void findFormulaTest() {
	    	FindCompoundingFormulaRequest request = transformRequest<FindCompoundingFormulaRequest>(".\\examples\\request\\findFormulaRequest.xml", typeof(FindCompoundingFormulaRequest));
	        FindCompoundingFormulaResponse response = DicsSessionServiceFactory.getDicsSession().findFormula(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findFormulaResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findFormulaErrorTest() {
	    	FindCompoundingFormulaRequest request = transformRequest<FindCompoundingFormulaRequest>(".\\examples\\request\\findFormulaRequest-error.xml", typeof(FindCompoundingFormulaRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findFormula(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1014", "No formula found for given criteria.");
	        }
	    }
	
	    [Test]
	    [Ignore]
	    public void findAmppTest() {
	    	FindAmppRequest request = transformRequest<FindAmppRequest>(".\\examples\\request\\findAmppRequest.xml", typeof(FindAmppRequest));
	        FindAmppResponse response = DicsSessionServiceFactory.getDicsSession().findAmpp(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findAmppResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    [Ignore]
	    public void findAmppErrorTest() {
	    	FindAmppRequest request = transformRequest<FindAmppRequest>(".\\examples\\request\\findAmppRequest-error.xml", typeof(FindAmppRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findAmpp(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "", "", "");
	        }
	    }
	
	    [Test]
	    public void findNonMedicinalProductTest() {
	    	FindNonMedicinalProductRequest request = transformRequest<FindNonMedicinalProductRequest>(".\\examples\\request\\findNonMedicinalProductRequest.xml", typeof(FindNonMedicinalProductRequest));
	        FindNonMedicinalProductResponse response = DicsSessionServiceFactory.getDicsSession().findNonMedicinalProduct(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findNonMedicinalProductResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findNonMedicinalProductErrorTest() {
	    	FindNonMedicinalProductRequest request = transformRequest<FindNonMedicinalProductRequest>(".\\examples\\request\\findNonMedicinalProductRequest-error.xml", typeof(FindNonMedicinalProductRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findNonMedicinalProduct(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1015", "No non medicinal products found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void findListOfAmpTest() {
	    	FindListOfAmpRequest request = transformRequest<FindListOfAmpRequest>(".\\examples\\request\\findListOfAmpRequest.xml", typeof(FindListOfAmpRequest));
	        FindListOfAmpResponse response = DicsSessionServiceFactory.getDicsSession().findListOfAmp(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findListOfAmpResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void findListOfAmpErrorTest() {
	    	FindListOfAmpRequest request = transformRequest<FindListOfAmpRequest>(".\\examples\\request\\findListOfAmpRequest-error.xml", typeof(FindListOfAmpRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().findListOfAmp(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1003", "No AMP found for given criteria.");
	        }
	    }
	
	    [Test]
	    public void validateSamIdTest() {
	    	FindAmpRequest findAmpRequest = transformRequest<FindAmpRequest>(".\\examples\\request\\findAmpRequest.xml", typeof(FindAmpRequest));
	        FindAmpResponse findAmpResponse = DicsSessionServiceFactory.getDicsSession().findAmp(findAmpRequest);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findAmpResponse.xml"), ConnectorXmlUtils.toString(findAmpResponse));
	
	        Map extraContext = new HashMap();
	        extraContext.put("samId", findAmpResponse.getSamId());
	
	        ValidateSamIdRequest request = transformRequest<ValidateSamIdRequest>(".\\examples\\request\\validateSamIdRequest.xml", typeof(ValidateSamIdRequest), extraContext);
	        ValidateSamIdResponse response = DicsSessionServiceFactory.getDicsSession().validateSamId(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\validateSamIdResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void validateSamIdErrorTest() {
	    	ValidateSamIdRequest request = transformRequest<ValidateSamIdRequest>(".\\examples\\request\\validateSamIdRequest-error.xml", typeof(ValidateSamIdRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().validateSamId(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1301", "Could not parse SamId because it is invalid.");
	        }
	    }
	
	    [Test]
	    public void validateProductIdTest() {
	    	ValidateProductIdRequest request = transformRequest<ValidateProductIdRequest>(".\\examples\\request\\validateProductIdRequest.xml", typeof(ValidateProductIdRequest));
	        ValidateProductIdResponse response = DicsSessionServiceFactory.getDicsSession().validateProductId(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\validateProductIdResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void validateProductIdErrorTest() {
	    	ValidateProductIdRequest request = transformRequest<ValidateProductIdRequest>(".\\examples\\request\\validateProductIdRequest-error.xml", typeof(ValidateProductIdRequest));
	        try {
	            DicsSessionServiceFactory.getDicsSession().validateProductId(request);
	        } catch (DicsException de) {
	            assertDicsException(de, "Consumer", "1301", "Could not parse SamId because it is invalid.");
	        }
	    }
	
	    private void assertDicsException(DicsException dicsException, string origin, string code, string message) {
	        java.util.List entries = new ArrayList();
	        Iterator it = dicsException.getFault().getDetail().getDetailEntries();
	        while (it.hasNext()) entries.add((DetailEntry) it.next());
	
	        Assert.AreEqual(1, entries.size());
	
	        MarshallerHelper helper = new MarshallerHelper(typeof(BusinessError), typeof(BusinessError));
	        BusinessError error = (BusinessError) helper.toObject((org.w3c.dom.Node) entries.get(0));
	
	        Assert.AreEqual(code, error.getCode());
	        Assert.AreEqual(origin, error.getOrigin());
	
	        java.util.List messages = error.getMessages();
	        Assert.AreEqual(1, messages.size());
	        Assert.AreEqual(message, ((LocalisedStringType) messages.get(0)).getValue());
	    }
	
	    private T transformRequest<T>(string fileLocation, Class clazz) {
	        return transformRequest<T>(fileLocation, clazz, null);
	    }
	
	    private T transformRequest<T>(string fileLocation, Class clazz, Map extraContext) {
	        Map velocityContext = new HashMap();
	        velocityContext.put("issueInstant", DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'+02:00'").print(new org.joda.time.DateTime()));
	        velocityContext.put("requestId", IdGeneratorFactory.getIdGenerator("uuid").generateId());
	        velocityContext.put("currentDate", DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
	        velocityContext.put("generatedChars1", RandomStringUtils.randomAlphabetic(10).ToLower());
	        velocityContext.put("generatedChars2", RandomStringUtils.randomAlphabetic(10).ToLower());
	
	        if (extraContext != null && !extraContext.isEmpty()) {
	        	Iterator it = extraContext.keySet().iterator();
	        	while (it.hasNext()) {
	        		string key = (string) it.next();
	        		velocityContext.put(key, extraContext.get(key));
	        	}
	        }
	
	        return (T) FileTestUtils.toObject(velocityContext, fileLocation, clazz);
	    }
	}
}
