/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetdomaincommons.util;

import be.ehealth.technicalconnector.config.ConfigFactory;

public class PropertyUtil {
    public static String retrieveProjectNameToUse(String projectName, String prefix) {
        return PropertyUtil.retrieveProjectNameToUse(projectName, prefix, "");
    }

    public static String retrieveProjectNameToUse(String projectName, String prefix, String suffix) {
        if (prefix == null || suffix == null) {
            throw new IllegalArgumentException("parameters prefix and suffix cannot be null");
        }
        if (projectName == null || projectName.isEmpty()) {
            return "default";
        }
        prefix = PropertyUtil.endPrefixWithDotIfNeeded(prefix);
        suffix = PropertyUtil.startSuffixWithDotIfNeeded(suffix);
        String key = prefix + projectName + suffix + ".usedefaultproperties";
        String useDefaultPropertiesString = ConfigFactory.getConfigValidator().getProperty(key, "true");
        if (useDefaultPropertiesString == null || "true".equals(useDefaultPropertiesString)) {
            return "default";
        }
        return projectName;
    }

    private static String startSuffixWithDotIfNeeded(String suffix) {
        if (!suffix.isEmpty() && !suffix.startsWith(".")) {
            suffix = "." + suffix;
        }
        return suffix;
    }

    private static String endPrefixWithDotIfNeeded(String prefix) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        return prefix;
    }
}

