using be.ehealth.technicalconnector.beid.domain;
using be.fedict.commons.eid.consumer.tlv;
using be.fgov.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using java.lang;

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/**
 * IntegrationTest for BeIDInfo
 */
namespace be.ehealth.technicalconnector.beid
{
	using System;
	using System.Security.Cryptography;
	using System.Windows.Forms;

	using be.ehealth.technicalconnector.beid;
	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.service.sts.security.impl.beid.impl;
	using be.ehealth.technicalconnector.session;
	using be.ehealth.technicalconnector.utils;
	using be.fgov.ehealth.technicalconnector.tests.utils.net;
	using be.fedict.commons.eid.client;

	using java.util;

	using NUnit.Framework;

	[TestFixture]
	public class BeIDInfoUserIntegrationTest
	{
		#region Methods

		[SetUp]
		public void init (){
			SessionInitializer.init(false);
		}
		
		[Test]
		public void validateIdentityMapping() {

			byte[] identityFile = BeIDCardFactory.getBeIDCard().readFile(FileType.Identity);
			be.fedict.commons.eid.consumer.Identity expected =(be.fedict.commons.eid.consumer.Identity) TlvParser.parse(identityFile, typeof(be.fedict.commons.eid.consumer.Identity));

			Identity actual = BeIDInfo.getInstance("validateMapping").getIdentity();


			Assert.AreEqual(expected.getCardDeliveryMunicipality(), actual.getCardDeliveryMunicipality());
			Assert.AreEqual(expected.getCardNumber(), actual.getCardNumber());
			Assert.AreEqual(expected.getCardValidityDateBegin().getTimeInMillis(), actual.getCardValidityDateBegin().getMillis());
			Assert.AreEqual(expected.getCardValidityDateEnd().getTimeInMillis(), actual.getCardValidityDateEnd().getMillis());
			Assert.AreEqual(expected.getChipNumber(), actual.getChipNumber());
			Assert.AreEqual(expected.getData(), actual.getData());
			Assert.AreEqual(expected.getDateOfBirth().getTimeInMillis(), actual.getDateOfBirth().getMillis());
			Assert.AreEqual(expected.getDocumentType().name(), actual.getDocumentType().name());
			Assert.AreEqual(expected.getDuplicate(), actual.getDuplicate());
			Assert.AreEqual(expected.getFirstName(), actual.getFirstName());
			Assert.AreEqual(expected.getGender().name(), actual.getGender().name());
			Assert.AreEqual(expected.getMiddleName(), actual.getMiddleName());
			Assert.AreEqual(expected.getName(), actual.getName());
			Assert.AreEqual(expected.getNationality(), actual.getNationality());
			Assert.AreEqual(expected.getNationalNumber(), actual.getNationalNumber());
			Assert.AreEqual(expected.getNobleCondition(), actual.getNobleCondition());
			Assert.AreEqual(expected.getPhotoDigest(), actual.getPhotoDigest());
			Assert.AreEqual(expected.getPlaceOfBirth(), actual.getPlaceOfBirth());
			SpecialOrganisation specialOrganisation = actual.getSpecialOrganisation();
			if (specialOrganisation != null) {
				Assert.AreEqual(expected.getSpecialOrganisation().name(), specialOrganisation.name());
			} else {
				Assert.AreEqual(expected.getSpecialOrganisation(), specialOrganisation);
			}
			Assert.AreEqual(expected.getSpecialStatus().name(), actual.getSpecialStatus().name());
			Assert.AreEqual(expected.isMemberOfFamily(), actual.isMemberOfFamily());

		}

		[Test]
		public void validateAddressingMapping() {

			byte[] identityFile = BeIDCardFactory.getBeIDCard().readFile(FileType.Address);
			be.fedict.commons.eid.consumer.Address expected = (be.fedict.commons.eid.consumer.Address)TlvParser.parse(identityFile, typeof(be.fedict.commons.eid.consumer.Address));

			Address actual = BeIDInfo.getInstance("validateMapping").getAddress();

			Assert.AreEqual(expected.getData(), actual.getData());
			Assert.AreEqual(expected.getMunicipality(), actual.getMunicipality());
			Assert.AreEqual(expected.getStreetAndNumber(), actual.getStreetAndNumber());
			Assert.AreEqual(expected.getZip(), actual.getZip());


		}

		/**
		 * Reads the identity card and checks the values received with the values in the properties file.
		 */
		[Test]
		public void readBeID() {
			Properties props = TestPropertiesNetLoader.getProperties(".\\be.ehealth.technicalconnector.test.properties",SupportedLanguages.NET.getAbbreviation());

			BeIDInfo actual = BeIDInfo.getInstance("test");
			Assume.That(props.getProperty("test.session.user").Equals(actual.getIdentity().getNationalNumber()));
			Assert.AreEqual(props.getProperty("test.session.firstname"), actual.getIdentity().getFirstName());
			Assert.AreEqual(props.getProperty("test.session.lastname"), actual.getIdentity().getName());


		}

		public static string ShowDialog(string text, string caption)
		{
			Form prompt = new Form();
			prompt.Width = 500;
			prompt.Height = 150;
			prompt.Text = caption;
			Label textLabel = new Label() { Left = 50, Top=20, Width=400, Text=text };
			TextBox textBox = new TextBox() { Left = 50, Top=50, Width=400 };
			textBox.PasswordChar='*';
			Button confirmation = new Button() { Text = "Ok", Left=350, Width=100, Top=70 };
			confirmation.Click += (sender, e) => { prompt.Close(); };
			prompt.Controls.Add(confirmation);
			prompt.Controls.Add(textLabel);
			prompt.Controls.Add(textBox);
			prompt.ShowDialog();
			return textBox.Text;
		}
		
		[Test]
		public void customDialog()
		{
			ConfigValidator config =  ConfigFactory.getConfigValidator();
			config.setProperty("beidcardgui.class","be.ehealth.technicalconnector.service.sts.security.impl.beid.impl.BeIDConnectorExternalGui");

			BeIDInfo beIDInfo = BeIDInfo.getInstance("testCustomDialog");
			config.setProperty("user.inss",beIDInfo.getIdentity().getNationalNumber());

			string promptValue = ShowDialog("Pincode", "PinCode requested");
			BeIDConnectorExternalGui externalGui =BeIDConnectorExternalGui.getInstance();
			externalGui.setPIN(PINPurpose.AuthenticationSignature,promptValue.ToCharArray());
			externalGui.setPIN(PINPurpose.NonRepudiationSignature,promptValue.ToCharArray());

			Session.getInstance().createSessionEidOnly();
		}

		#endregion Methods
	}
}