/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.impl;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.service.sts.STSService;
import be.ehealth.technicalconnector.service.sts.domain.SAMLNameIdentifier;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.utils.DateUtils;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class AbstractSTSService
implements STSService {
    public static final String HOK_METHOD = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    public static final String SV_METHOD = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
    protected static final String NAMEID_UNSPECIFIED = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    protected static final String NAMEID_X509SUBJECTNAME = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
    protected static final String XMLNS_WSSE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    protected static final String XMLNS_DS = "http://www.w3.org/2000/09/xmldsig#";
    protected static final String XMLNS_WSU = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    protected static final String XMLNS_AUTH = "http://docs.oasis-open.org/wsfed/authorization/200706";
    protected static final String XMLNS_WST = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    protected static final String XMLNS_SAML = "urn:oasis:names:tc:SAML:1.0:assertion";
    protected static final String XMLNS_SAMLP = "urn:oasis:names:tc:SAML:1.0:protocol";

    private SAMLNameIdentifier generateNameIdentifier(X509Certificate authnCertificate) throws TechnicalConnectorException {
        Validate.notNull((Object)authnCertificate, (String)"Parameter authnCertificate is not nullable.");
        String cn = authnCertificate.getSubjectX500Principal().getName("RFC1779");
        String ca = authnCertificate.getIssuerX500Principal().getName("RFC1779");
        return new SAMLNameIdentifier(StringEscapeUtils.escapeXml((String)cn), NAMEID_X509SUBJECTNAME, StringEscapeUtils.escapeXml((String)ca), StringEscapeUtils.escapeXml((String)cn));
    }

    protected String processDefaultFields(String requestTemplate, int validity, SAMLNameIdentifier nameIdentifier) throws TechnicalConnectorException {
        String result = requestTemplate;
        DateTime now = new DateTime();
        String uuid = IdGeneratorFactory.getIdGenerator("uuid").generateId();
        String notBefore = DateUtils.printDateTime((DateTime)now.toDateTime(DateTimeZone.UTC));
        String notAfter = DateUtils.printDateTime((DateTime)now.plusHours(validity).toDateTime(DateTimeZone.UTC));
        result = StringUtils.replace((String)result, (String)"${uuid}", (String)uuid);
        result = StringUtils.replace((String)result, (String)"${NotBefore}", (String)notBefore);
        result = StringUtils.replace((String)result, (String)"${NotOnOrAfter}", (String)notAfter);
        result = StringUtils.replace((String)result, (String)"${issuer}", (String)nameIdentifier.getAssertionIssuer());
        result = StringUtils.replace((String)result, (String)"${nameid.format}", (String)nameIdentifier.getFormat());
        result = StringUtils.replace((String)result, (String)"${nameid.qualifier}", (String)nameIdentifier.getNameQualifier());
        result = StringUtils.replace((String)result, (String)"${nameid.value}", (String)nameIdentifier.getValue());
        return result;
    }

    protected SAMLNameIdentifier generateNameIdentifier(Credential headerCredentials, String nameQualifier, String value) throws TechnicalConnectorException {
        SAMLNameIdentifier nameId = null;
        nameId = StringUtils.isEmpty((String)nameQualifier) && StringUtils.isEmpty((String)value) ? this.generateNameIdentifier(headerCredentials.getCertificate()) : new SAMLNameIdentifier(nameQualifier, NAMEID_UNSPECIFIED, nameQualifier, value);
        return nameId;
    }
}

