/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.status;

import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.CryptoResultException;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.status.NotificationFatal;
import be.fgov.ehealth.etee.crypto.status.NotificationWarning;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class BasicCryptoResult<T>
implements CryptoResult<T> {
    private static final Logger LOGGER = Logger.getLogger(BasicCryptoResult.class);
    private T data;
    private NotificationFatal fatal;
    private final List<NotificationError> errors = new ArrayList<NotificationError>();
    private final List<NotificationWarning> warnings = new ArrayList<NotificationWarning>();
    private boolean errorsFetched;
    private boolean warningsFetched;

    public BasicCryptoResult() {
    }

    public BasicCryptoResult(T data) {
        this.data = data;
    }

    public BasicCryptoResult(NotificationFatal fatal) {
        this.fatal = fatal;
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public boolean hasErrors() {
        return this.fatal != null || !this.errors.isEmpty();
    }

    @Override
    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    @Override
    public List<NotificationError> getErrors() {
        this.errorsFetched = true;
        return this.errors;
    }

    @Override
    public List<NotificationWarning> getWarnings() {
        this.warningsFetched = true;
        return this.warnings;
    }

    @Override
    public NotificationFatal getFatal() {
        return this.fatal;
    }

    @Override
    public T getData() {
        if (this.fatal != null) {
            LOGGER.fatal((Object)("Fatal error produced during cryptographic process = " + (Object)((Object)this.fatal)));
            throw new CryptoResultException("The cryptographic process failed and could not be completed. There is no data available. Check Notifications for the source of the problems.");
        }
        if (!this.errors.isEmpty() && !this.errorsFetched) {
            LOGGER.error((Object)("Errors produced during cryptographic process = " + this.errors));
            throw new CryptoResultException("The cryptographic process completed with errors. You MUST verify the notifications before fetching the data.");
        }
        if (!this.warnings.isEmpty() && !this.warningsFetched) {
            LOGGER.warn((Object)("Warnings produced during cryptographic process = " + this.warnings));
            LOGGER.warn((Object)"The cryptographic process completed with warnings. You SHOULD verify the notifications before fetching the data.");
        }
        return this.data;
    }

    public String toString() {
        StringBuilder rslt = new StringBuilder("CryptoResult Notifications [");
        rslt.append("Fatal = ").append(this.fatal == null ? "[]" : this.fatal);
        rslt.append("Errors ").append(this.errors.isEmpty() ? "= []" : "(acceptance of a result with errors is a violation of eHealth Policy) = " + this.errors);
        rslt.append("Warnings ").append(this.warnings.isEmpty() ? "= []" : "(acceptance of a result with warnings is a matter of a recipient's discretion) = " + this.warnings);
        rslt.append("]");
        return rslt.toString();
    }

    @Override
    public void copyNotifications(CryptoResult<?> subResult) {
        this.fatal = subResult.getFatal();
        this.errors.addAll(subResult.getErrors());
        this.warnings.addAll(subResult.getWarnings());
    }

    public void setData(T data) {
        this.data = data;
    }

    protected T getDataUnchecked() {
        return this.data;
    }
}

