/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.CMSMessageContext;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReaderAbstract;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReaderException;
import be.fgov.ehealth.etee.crypto.status.CMSErrorType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Store;

class CMSByteArrayReader
extends CMSReaderAbstract<byte[]> {
    private static final Logger LOGGER = Logger.getLogger(CMSByteArrayReader.class);
    private CMSSignedData cmsSignedData;

    CMSByteArrayReader() {
    }

    @Override
    public void read(CMSMessageContext<byte[]> msgContext) throws CMSReaderException {
        this.initSignedDataBlock(msgContext);
        super.read(msgContext);
    }

    @Override
    public void readSignedContent(CMSMessageContext<byte[]> msgContext) throws CMSReaderException {
        this.initSignedDataBlock(msgContext);
        LOGGER.debug((Object)"Reading the signed content from the Signed-Data.");
        if (msgContext.getContentStream() == null) {
            CMSTypedData signedContent = this.cmsSignedData.getSignedContent();
            if (signedContent == null) {
                throw new CMSReaderException(CMSErrorType.CONTENT_MISSING);
            }
            msgContext.setContentStream(new ByteArrayInputStream(this.toByteArray((CMSProcessable)signedContent)));
        }
    }

    @Override
    public void readSignerInformation(CMSMessageContext<byte[]> msgContext) throws CMSReaderException {
        if (msgContext.getSignerInformation() == null) {
            SignerInformationStore signerInformationStore = this.cmsSignedData.getSignerInfos();
            if (signerInformationStore == null) {
                throw new CMSReaderException(CMSErrorType.NO_SIGNER_INFOS);
            }
            if (signerInformationStore.getSigners().size() != 1) {
                throw new CMSReaderException(CMSErrorType.MORE_THAN_1_SIGNER_INFO);
            }
            Iterator iterator = signerInformationStore.getSigners().iterator();
            SignerInformation signerInfo = (SignerInformation)iterator.next();
            LOGGER.info((Object)(CMSErrorType.SIGNER_INFO_FOUND.getMsg() + signerInfo.getSID()));
            msgContext.setSignerInformation(signerInfo);
        }
    }

    @Override
    public void readCertificates(CMSMessageContext<byte[]> msgContext) throws CMSReaderException {
        if (msgContext.getCertificateStore() == null) {
            Store store = this.cmsSignedData.getCertificates();
            msgContext.setCertificateStore((Store<X509CertificateHolder>)store);
            try {
                msgContext.getCertificateChain().addAll(this.extractCertificateChain((Store<X509CertificateHolder>)store));
            }
            catch (CertificateException e) {
                throw new CMSReaderException(CMSErrorType.INCORRECTLY_ENCODED_CERTIFICATES, e);
            }
        }
    }

    private byte[] toByteArray(CMSProcessable signedContent) throws CMSReaderException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            signedContent.write((OutputStream)baos);
        }
        catch (Exception e) {
            throw new CMSReaderException(CMSErrorType.PARSE_ERROR, e);
        }
        return baos.toByteArray();
    }

    private void initSignedDataBlock(CMSMessageContext<byte[]> msgContext) throws CMSReaderException {
        if (this.cmsSignedData == null) {
            try {
                this.cmsSignedData = new CMSSignedData(msgContext.getMessage());
            }
            catch (Exception e) {
                throw new CMSReaderException(CMSErrorType.PARSE_ERROR, e);
            }
        }
    }
}

