/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.tests.junit;

import java.io.InputStream;

import javax.xml.XMLConstants;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;

import be.ehealth.technicalconnector.service.ws.ServiceFactory;


/**
 * Abstract class allowing to validate if the XSD are correcly present on the classpath. *
 * 
 * @author EHP
 * 
 */
public abstract class AbstractXSDLocationTest {

    protected void validateSchemaFiles(String... schemaFiles) throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        Source[] sources = new Source[]{};
        for (String xsd : schemaFiles) {
            InputStream in = ServiceFactory.class.getResourceAsStream(xsd);
            Assert.assertNotNull(in);
            Assert.assertNotNull("Could not find file:" + xsd, in);
            Source source = new StreamSource(in);
            sources = (Source[]) ArrayUtils.add(sources, source);
        }
        schemaFactory.newSchema(sources);
    }

    protected void validateSchemaFiles(String schemaFile) throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        schemaFactory.newSchema(this.getClass().getResource(schemaFile));
    }

}
