/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModuleVersion
implements ConfigurationModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleVersion.class);

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        LOG.debug("Initializing ConfigurationModule " + this.getClass().getName());
        if (LOG.isDebugEnabled()) {
            this.getJarFromCP();
        }
    }

    public void getJarFromCP() {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            Object[] cpElements = ArrayUtils.EMPTY_STRING_ARRAY;
            while (resEnum.hasMoreElements()) {
                URL url = resEnum.nextElement();
                StringBuilder sb = new StringBuilder("[CP Content] ");
                String substringAfterLast = StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)url.getPath(), (String)"!"), (String)"/");
                if ("MANIFEST.MF".equals(substringAfterLast)) continue;
                sb.append(substringAfterLast);
                cpElements = (String[])ArrayUtils.add((Object[])cpElements, (Object)sb.toString());
            }
            Arrays.sort(cpElements);
            for (Object cpElement : cpElements) {
                LOG.debug((String)cpElement);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void unload() throws TechnicalConnectorException {
    }
}

